/*
 * Decompiled with CFR 0.152.
 */
package de.janno.evaluator.dice.function;

import com.google.common.collect.ImmutableList;
import de.janno.evaluator.dice.ExpressionException;
import de.janno.evaluator.dice.Function;
import de.janno.evaluator.dice.Roll;
import de.janno.evaluator.dice.RollBuilder;
import de.janno.evaluator.dice.RollElement;
import de.janno.evaluator.dice.UniqueRandomElements;
import de.janno.evaluator.dice.ValidatorUtil;
import java.util.List;
import lombok.NonNull;

public class Cancel
extends Function {
    public Cancel() {
        super("cancel", 3);
    }

    @Override
    @NonNull
    public RollBuilder evaluate(@NonNull List<RollBuilder> arguments) throws ExpressionException {
        if (arguments == null) {
            throw new NullPointerException("arguments is marked non-null but is null");
        }
        return constants -> {
            List<Roll> rolls = RollBuilder.extendAllBuilder(arguments, constants);
            ValidatorUtil.checkRollSize(this.getName(), rolls, this.getMinArgumentCount(), this.getMaxArgumentCount());
            Roll input = rolls.get(0);
            Roll typeA = rolls.get(1);
            Roll typeB = rolls.get(2);
            List noMatch = (List)input.getElements().stream().filter(r -> !typeA.getElements().contains(r) && !typeB.getElements().contains(r)).collect(ImmutableList.toImmutableList());
            List typeAMatch = (List)input.getElements().stream().filter(r -> typeA.getElements().contains(r)).collect(ImmutableList.toImmutableList());
            List typeBMatch = (List)input.getElements().stream().filter(r -> typeB.getElements().contains(r)).collect(ImmutableList.toImmutableList());
            ImmutableList.Builder resultBuilder = ImmutableList.builder().addAll((Iterable)noMatch);
            if (typeAMatch.size() > typeBMatch.size()) {
                resultBuilder.addAll(this.getChancel(typeAMatch, typeBMatch));
            } else if (typeAMatch.size() < typeBMatch.size()) {
                resultBuilder.addAll(this.getChancel(typeBMatch, typeAMatch));
            }
            return ImmutableList.of((Object)new Roll(Cancel.getExpression(this.getName(), rolls), (ImmutableList<RollElement>)resultBuilder.build(), UniqueRandomElements.from(rolls), (ImmutableList<Roll>)ImmutableList.builder().addAll(input.getChildrenRolls()).addAll(typeA.getChildrenRolls()).addAll(typeB.getChildrenRolls()).build()));
        };
    }

    private List<RollElement> getChancel(List<RollElement> bigger, List<RollElement> smaller) {
        return bigger.subList(smaller.size(), bigger.size());
    }
}

