/*
 * Decompiled with CFR 0.152.
 */
package de.janno.evaluator.dice.function;

import com.google.common.collect.ImmutableList;
import de.janno.evaluator.dice.ExpressionException;
import de.janno.evaluator.dice.Function;
import de.janno.evaluator.dice.Roll;
import de.janno.evaluator.dice.RollBuilder;
import de.janno.evaluator.dice.RollElement;
import de.janno.evaluator.dice.UniqueRandomElements;
import de.janno.evaluator.dice.ValidatorUtil;
import java.util.List;
import lombok.NonNull;

public class Color
extends Function {
    public Color() {
        super("color", 2);
    }

    @Override
    @NonNull
    public RollBuilder evaluate(@NonNull List<RollBuilder> arguments) throws ExpressionException {
        if (arguments == null) {
            throw new NullPointerException("arguments is marked non-null but is null");
        }
        return constants -> {
            List<Roll> rolls = RollBuilder.extendAllBuilder(arguments, constants);
            ValidatorUtil.checkRollSize(this.getName(), rolls, this.getMinArgumentCount(), this.getMaxArgumentCount());
            Roll p1 = rolls.get(0);
            Roll p2 = rolls.get(1);
            ValidatorUtil.checkContainsSingleElement(this.getName(), p2, "second argument");
            String color = ((RollElement)p2.getElements().get(0)).getValue();
            return ImmutableList.of((Object)new Roll(Color.getExpression(this.getName(), rolls), (ImmutableList<RollElement>)((ImmutableList)p1.getElements().stream().map(r -> new RollElement(r.getValue(), color)).collect(ImmutableList.toImmutableList())), UniqueRandomElements.from(rolls), p1.getChildrenRolls()));
        };
    }
}

