/*
 * Decompiled with CFR 0.152.
 */
package de.janno.evaluator.dice.function;

import com.google.common.collect.ImmutableList;
import de.janno.evaluator.dice.ExpressionException;
import de.janno.evaluator.dice.Function;
import de.janno.evaluator.dice.Roll;
import de.janno.evaluator.dice.RollBuilder;
import de.janno.evaluator.dice.RollElement;
import de.janno.evaluator.dice.UniqueRandomElements;
import de.janno.evaluator.dice.ValidatorUtil;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;

public class Concat
extends Function {
    public Concat() {
        super("concat", 2, Integer.MAX_VALUE);
    }

    @Override
    @NonNull
    public RollBuilder evaluate(@NonNull List<RollBuilder> arguments) throws ExpressionException {
        if (arguments == null) {
            throw new NullPointerException("arguments is marked non-null but is null");
        }
        return constants -> {
            List<Roll> rolls = RollBuilder.extendAllBuilder(arguments, constants);
            ValidatorUtil.checkRollSize(this.getName(), rolls, this.getMinArgumentCount(), this.getMaxArgumentCount());
            String joined = rolls.stream().map(Roll::getResultString).collect(Collectors.joining());
            return ImmutableList.of((Object)new Roll(Concat.getExpression(this.getName(), rolls), (ImmutableList<RollElement>)ImmutableList.of((Object)new RollElement(joined, "")), UniqueRandomElements.from(rolls), (ImmutableList<Roll>)ImmutableList.copyOf(rolls)));
        };
    }
}

