/*
 * Decompiled with CFR 0.152.
 */
package de.janno.evaluator.dice.function;

import com.google.common.collect.ImmutableList;
import de.janno.evaluator.dice.ExpressionException;
import de.janno.evaluator.dice.Function;
import de.janno.evaluator.dice.Roll;
import de.janno.evaluator.dice.RollBuilder;
import de.janno.evaluator.dice.RollElement;
import de.janno.evaluator.dice.UniqueRandomElements;
import de.janno.evaluator.dice.ValidatorUtil;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;

public class GroupCount
extends Function {
    public GroupCount() {
        super("groupC", 1, Integer.MAX_VALUE);
    }

    @Override
    @NonNull
    public RollBuilder evaluate(@NonNull List<RollBuilder> arguments) throws ExpressionException {
        if (arguments == null) {
            throw new NullPointerException("arguments is marked non-null but is null");
        }
        return constants -> {
            List<Roll> rolls = RollBuilder.extendAllBuilder(arguments, constants);
            ValidatorUtil.checkRollSize(this.getName(), rolls, this.getMinArgumentCount(), this.getMaxArgumentCount());
            ImmutableList res = (ImmutableList)rolls.stream().flatMap(result -> result.getElements().stream()).collect(Collectors.groupingBy(java.util.function.Function.identity())).entrySet().stream().sorted(Comparator.comparingInt(o -> ((List)o.getValue()).size()).reversed()).map(entry -> new RollElement("%dx%s".formatted(((List)entry.getValue()).size(), ((RollElement)entry.getKey()).getValue()), ((RollElement)entry.getKey()).getColor())).collect(ImmutableList.toImmutableList());
            return ImmutableList.of((Object)new Roll(GroupCount.getExpression(this.getName(), rolls), (ImmutableList<RollElement>)res, UniqueRandomElements.from(rolls), (ImmutableList<Roll>)ImmutableList.copyOf(rolls)));
        };
    }
}

