/*
 * Decompiled with CFR 0.152.
 */
package de.janno.evaluator.dice.function;

import com.google.common.collect.ImmutableList;
import de.janno.evaluator.dice.ExpressionException;
import de.janno.evaluator.dice.Function;
import de.janno.evaluator.dice.Roll;
import de.janno.evaluator.dice.RollBuilder;
import de.janno.evaluator.dice.RollElement;
import de.janno.evaluator.dice.UniqueRandomElements;
import de.janno.evaluator.dice.ValidatorUtil;
import java.util.List;
import lombok.NonNull;

public class Min
extends Function {
    public Min() {
        super("min", 1, Integer.MAX_VALUE);
    }

    @Override
    @NonNull
    public RollBuilder evaluate(@NonNull List<RollBuilder> arguments) throws ExpressionException {
        if (arguments == null) {
            throw new NullPointerException("arguments is marked non-null but is null");
        }
        return constants -> {
            List<Roll> rolls = RollBuilder.extendAllBuilder(arguments, constants);
            ValidatorUtil.checkRollSize(this.getName(), rolls, this.getMinArgumentCount(), this.getMaxArgumentCount());
            RollElement min = (RollElement)rolls.stream().flatMap(result -> result.getElements().stream()).min(RollElement::compareTo).orElseThrow();
            ImmutableList res = (ImmutableList)rolls.stream().flatMap(result -> result.getElements().stream()).filter(resultElement -> resultElement.compareTo(min) == 0).collect(ImmutableList.toImmutableList());
            return ImmutableList.of((Object)new Roll(Min.getExpression(this.getName(), rolls), (ImmutableList<RollElement>)res, UniqueRandomElements.from(rolls), (ImmutableList<Roll>)ImmutableList.copyOf(rolls)));
        };
    }
}

