/*
 * Decompiled with CFR 0.152.
 */
package de.janno.evaluator.dice.function;

import com.google.common.collect.ImmutableList;
import de.janno.evaluator.dice.ExpressionException;
import de.janno.evaluator.dice.Function;
import de.janno.evaluator.dice.Roll;
import de.janno.evaluator.dice.RollBuilder;
import de.janno.evaluator.dice.RollElement;
import de.janno.evaluator.dice.UniqueRandomElements;
import de.janno.evaluator.dice.ValidatorUtil;
import java.util.List;
import java.util.stream.Stream;
import lombok.NonNull;

public class Replace
extends Function {
    public Replace() {
        super("replace", 3);
    }

    @Override
    @NonNull
    public RollBuilder evaluate(@NonNull List<RollBuilder> arguments) throws ExpressionException {
        if (arguments == null) {
            throw new NullPointerException("arguments is marked non-null but is null");
        }
        return constants -> {
            List<Roll> rolls = RollBuilder.extendAllBuilder(arguments, constants);
            ValidatorUtil.checkRollSize(this.getName(), rolls, this.getMinArgumentCount(), this.getMaxArgumentCount());
            Roll input = rolls.get(0);
            Roll find = rolls.get(1);
            Roll replace = rolls.get(2);
            ImmutableList rollElements = (ImmutableList)input.getElements().stream().flatMap(r -> {
                if (find.getElements().contains(r)) {
                    return replace.getElements().stream();
                }
                return Stream.of(r);
            }).collect(ImmutableList.toImmutableList());
            return ImmutableList.of((Object)new Roll(Replace.getExpression(this.getName(), rolls), (ImmutableList<RollElement>)rollElements, UniqueRandomElements.from(rolls), (ImmutableList<Roll>)ImmutableList.builder().addAll(input.getChildrenRolls()).addAll(find.getChildrenRolls()).addAll(replace.getChildrenRolls()).build()));
        };
    }
}

