/*
 * Decompiled with CFR 0.152.
 */
package de.janno.evaluator.dice.function;

import com.google.common.collect.ImmutableList;
import de.janno.evaluator.dice.ExpressionException;
import de.janno.evaluator.dice.Function;
import de.janno.evaluator.dice.Roll;
import de.janno.evaluator.dice.RollBuilder;
import de.janno.evaluator.dice.RollElement;
import de.janno.evaluator.dice.UniqueRandomElements;
import de.janno.evaluator.dice.ValidatorUtil;
import java.util.List;
import lombok.NonNull;

public class Value
extends Function {
    public Value() {
        super("val", 2);
    }

    @Override
    @NonNull
    public RollBuilder evaluate(@NonNull List<RollBuilder> arguments) throws ExpressionException {
        if (arguments == null) {
            throw new NullPointerException("arguments is marked non-null but is null");
        }
        return constants -> {
            List<Roll> rolls = RollBuilder.extendAllBuilder(arguments, constants);
            ValidatorUtil.checkRollSize(this.getName(), rolls, this.getMinArgumentCount(), this.getMaxArgumentCount());
            String valName = ((RollElement)rolls.get(0).getElements().get(0)).getValue();
            if (constants.containsKey(valName)) {
                throw new ExpressionException("The value name '%s' was defined more than once.".formatted(valName));
            }
            constants.put(valName, new Roll(Value.getExpression(this.getName(), rolls), rolls.get(1).getElements(), UniqueRandomElements.from(rolls), rolls.get(1).getChildrenRolls()));
            return ImmutableList.of();
        };
    }
}

