/*
 * Decompiled with CFR 0.152.
 */
package de.janno.evaluator.dice.operator.die;

import com.google.common.collect.ImmutableList;
import de.janno.evaluator.dice.DiceHelper;
import de.janno.evaluator.dice.ExpressionException;
import de.janno.evaluator.dice.Operator;
import de.janno.evaluator.dice.RandomElement;
import de.janno.evaluator.dice.Roll;
import de.janno.evaluator.dice.RollBuilder;
import de.janno.evaluator.dice.RollElement;
import de.janno.evaluator.dice.UniqueRandomElements;
import de.janno.evaluator.dice.ValidatorUtil;
import de.janno.evaluator.dice.operator.OperatorOrder;
import de.janno.evaluator.dice.random.NumberSupplier;
import java.util.Collection;
import java.util.List;
import lombok.NonNull;

public final class ExplodingDice
extends Operator {
    private final NumberSupplier numberSupplier;
    private final int maxNumberOfDice;

    public ExplodingDice(NumberSupplier numberSupplier, int maxNumberOfDice) {
        super("d!", Operator.Associativity.RIGHT, OperatorOrder.getOderNumberOf(ExplodingDice.class), Operator.Associativity.LEFT, OperatorOrder.getOderNumberOf(ExplodingDice.class));
        this.numberSupplier = numberSupplier;
        this.maxNumberOfDice = maxNumberOfDice;
    }

    @Override
    @NonNull
    public RollBuilder evaluate(@NonNull List<RollBuilder> operands) throws ExpressionException {
        if (operands == null) {
            throw new NullPointerException("operands is marked non-null but is null");
        }
        return constants -> {
            List<Roll> rolls = RollBuilder.extendAllBuilder(operands, constants);
            ValidatorUtil.checkRollSize(this.getName(), rolls, 1, 2);
            UniqueRandomElements.Builder randomElements = UniqueRandomElements.builder();
            if (rolls.size() == 1) {
                Roll right = rolls.get(0);
                int sidesOfDie = right.asInteger().orElseThrow(() -> ValidatorUtil.throwNotIntegerExpression(this.getName(), right, "right"));
                if (sidesOfDie < 2) {
                    throw new ExpressionException(String.format("The number of sides of a die must be greater then 1 but was %d", sidesOfDie));
                }
                ImmutableList<RollElement> rollElements = DiceHelper.toRollElements(DiceHelper.explodingDice(1, sidesOfDie, this.numberSupplier));
                randomElements.add(right.getRandomElementsInRoll());
                randomElements.addAsRandomElements((Collection)rollElements.stream().map(r -> new RandomElement((RollElement)r, 1, sidesOfDie)).collect(ImmutableList.toImmutableList()));
                return ImmutableList.of((Object)new Roll(ExplodingDice.getRightUnaryExpression(this.getName(), rolls), rollElements, randomElements.build(), (ImmutableList<Roll>)ImmutableList.of((Object)right)));
            }
            Roll left = rolls.get(0);
            Roll right = rolls.get(1);
            randomElements.add(left.getRandomElementsInRoll());
            randomElements.add(right.getRandomElementsInRoll());
            int numberOfDice = left.asInteger().orElseThrow(() -> ValidatorUtil.throwNotIntegerExpression(this.getName(), left, "left"));
            if (numberOfDice > this.maxNumberOfDice) {
                throw new ExpressionException(String.format("The number of dice must be less or equal then %d but was %d", this.maxNumberOfDice, numberOfDice));
            }
            if (numberOfDice < 0) {
                throw new ExpressionException(String.format("The number of dice can not be negativ but was %d", numberOfDice));
            }
            int sidesOfDie = right.asInteger().orElseThrow(() -> ValidatorUtil.throwNotIntegerExpression(this.getName(), right, "right"));
            if (sidesOfDie < 2) {
                throw new ExpressionException(String.format("The number of sides of a die must be greater then 1 but was %d", sidesOfDie));
            }
            ImmutableList<RollElement> rollElements = DiceHelper.toRollElements(DiceHelper.explodingDice(numberOfDice, sidesOfDie, this.numberSupplier));
            randomElements.addAsRandomElements((Collection)rollElements.stream().map(r -> new RandomElement((RollElement)r, 1, sidesOfDie)).collect(ImmutableList.toImmutableList()));
            return ImmutableList.of((Object)new Roll(ExplodingDice.getBinaryOperatorExpression(this.getName(), rolls), rollElements, randomElements.build(), (ImmutableList<Roll>)ImmutableList.of((Object)left, (Object)right)));
        };
    }
}

