/*
 * Decompiled with CFR 0.152.
 */
package de.janno.evaluator.dice.operator.die;

import com.google.common.collect.ImmutableList;
import de.janno.evaluator.dice.DiceHelper;
import de.janno.evaluator.dice.ExpressionException;
import de.janno.evaluator.dice.Operator;
import de.janno.evaluator.dice.RandomElement;
import de.janno.evaluator.dice.Roll;
import de.janno.evaluator.dice.RollBuilder;
import de.janno.evaluator.dice.RollElement;
import de.janno.evaluator.dice.UniqueRandomElements;
import de.janno.evaluator.dice.ValidatorUtil;
import de.janno.evaluator.dice.operator.OperatorOrder;
import de.janno.evaluator.dice.random.NumberSupplier;
import java.util.Collection;
import java.util.List;
import lombok.NonNull;

public final class RegularDice
extends Operator {
    private final NumberSupplier numberSupplier;
    private final int maxNumberOfDice;

    public RegularDice(NumberSupplier numberSupplier, int maxNumberOfDice) {
        super("d", Operator.Associativity.RIGHT, OperatorOrder.getOderNumberOf(RegularDice.class), Operator.Associativity.LEFT, OperatorOrder.getOderNumberOf(RegularDice.class));
        this.numberSupplier = numberSupplier;
        this.maxNumberOfDice = maxNumberOfDice;
    }

    @Override
    @NonNull
    public RollBuilder evaluate(@NonNull List<RollBuilder> operands) throws ExpressionException {
        if (operands == null) {
            throw new NullPointerException("operands is marked non-null but is null");
        }
        return constants -> {
            ImmutableList<RollElement> rollElements;
            String expression;
            ImmutableList childrenRolls;
            int numberOfDice;
            Roll right;
            List<Roll> rolls = RollBuilder.extendAllBuilder(operands, constants);
            ValidatorUtil.checkRollSize(this.getName(), rolls, 1, 2);
            UniqueRandomElements.Builder randomElements = UniqueRandomElements.builder();
            if (rolls.size() == 1) {
                right = rolls.get(0);
                numberOfDice = 1;
                childrenRolls = ImmutableList.of((Object)right);
                expression = RegularDice.getRightUnaryExpression(this.getName(), rolls);
            } else if (rolls.size() == 2) {
                Roll left = rolls.get(0);
                right = rolls.get(1);
                childrenRolls = ImmutableList.of((Object)left, (Object)right);
                numberOfDice = left.asInteger().orElseThrow(() -> ValidatorUtil.throwNotIntegerExpression(this.getName(), left, "left"));
                expression = RegularDice.getBinaryOperatorExpression(this.getName(), rolls);
                randomElements.add(left.getRandomElementsInRoll());
            } else {
                throw new IllegalStateException("More then two operands for " + this.getName());
            }
            randomElements.add(right.getRandomElementsInRoll());
            if (numberOfDice > this.maxNumberOfDice) {
                throw new ExpressionException(String.format("The number of dice must be less or equal then %d but was %d", this.maxNumberOfDice, numberOfDice));
            }
            if (numberOfDice < 0) {
                throw new ExpressionException(String.format("The number of dice can not be negativ but was %d", numberOfDice));
            }
            if (right.asInteger().isPresent()) {
                int sidesOfDie = right.asInteger().get();
                rollElements = DiceHelper.toRollElements(DiceHelper.rollDice(numberOfDice, sidesOfDie, this.numberSupplier));
                randomElements.addAsRandomElements((Collection)rollElements.stream().map(r -> new RandomElement((RollElement)r, 1, sidesOfDie)).collect(ImmutableList.toImmutableList()));
            } else {
                ImmutableList.Builder builder = ImmutableList.builder();
                for (int i = 0; i < numberOfDice; ++i) {
                    builder.add((Object)DiceHelper.pickOneOf(right.getElements(), this.numberSupplier));
                }
                rollElements = builder.build();
                randomElements.addAsRandomElements((Collection)rollElements.stream().map(r -> new RandomElement((RollElement)r, (ImmutableList<String>)((ImmutableList)right.getElements().stream().map(RollElement::getValue).collect(ImmutableList.toImmutableList())))).collect(ImmutableList.toImmutableList()));
            }
            return ImmutableList.of((Object)new Roll(expression, rollElements, randomElements.build(), (ImmutableList<Roll>)childrenRolls));
        };
    }
}

