/*
 * Decompiled with CFR 0.152.
 */
package de.janno.evaluator.dice.operator.die;

import com.google.common.collect.ImmutableList;
import de.janno.evaluator.dice.ExpressionException;
import de.janno.evaluator.dice.Operator;
import de.janno.evaluator.dice.Roll;
import de.janno.evaluator.dice.RollBuilder;
import de.janno.evaluator.dice.UniqueRandomElements;
import de.janno.evaluator.dice.ValidatorUtil;
import de.janno.evaluator.dice.operator.OperatorOrder;
import java.util.List;
import lombok.NonNull;

public class Reroll
extends Operator {
    public Reroll() {
        super("rr", Operator.OperatorType.BINARY, Operator.Associativity.LEFT, OperatorOrder.getOderNumberOf(Reroll.class));
    }

    @Override
    @NonNull
    public RollBuilder evaluate(@NonNull List<RollBuilder> operands) throws ExpressionException {
        if (operands == null) {
            throw new NullPointerException("operands is marked non-null but is null");
        }
        return constants -> {
            RollBuilder inputBuilder = (RollBuilder)operands.get(0);
            List<Roll> compareTos = ((RollBuilder)operands.get(1)).extendRoll(constants);
            ValidatorUtil.checkRollSize(this.getName(), compareTos, 1, 1);
            Roll compareTo = compareTos.get(0);
            List<Roll> rolls = inputBuilder.extendRoll(constants);
            ValidatorUtil.checkRollSize(this.getName(), rolls, 1, 1);
            Roll roll = rolls.get(0);
            UniqueRandomElements.Builder builder = UniqueRandomElements.builder();
            builder.add(roll.getRandomElementsInRoll());
            if (roll.getElements().stream().anyMatch(r -> compareTo.getElements().contains(r))) {
                rolls = inputBuilder.extendRoll(constants);
                ValidatorUtil.checkRollSize(this.getName(), rolls, 1, 1);
                roll = rolls.get(0);
                builder.add(roll.getRandomElementsInRoll());
            }
            return ImmutableList.of((Object)new Roll(Reroll.getBinaryOperatorExpression(this.getName(), (List<Roll>)ImmutableList.of((Object)compareTo, (Object)roll)), roll.getElements(), builder.build(), (ImmutableList<Roll>)ImmutableList.builder().addAll(compareTo.getChildrenRolls()).addAll(roll.getChildrenRolls()).build()));
        };
    }
}

