/*
 * Decompiled with CFR 0.152.
 */
package de.janno.evaluator.dice.operator.list;

import com.google.common.collect.ImmutableList;
import de.janno.evaluator.dice.ExpressionException;
import de.janno.evaluator.dice.Operator;
import de.janno.evaluator.dice.Roll;
import de.janno.evaluator.dice.RollBuilder;
import de.janno.evaluator.dice.RollElement;
import de.janno.evaluator.dice.UniqueRandomElements;
import de.janno.evaluator.dice.ValidatorUtil;
import de.janno.evaluator.dice.operator.OperatorOrder;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;

public class Count
extends Operator {
    public Count() {
        super("c", Operator.Associativity.LEFT, OperatorOrder.getOderNumberOf(Count.class), null, null);
    }

    @Override
    @NonNull
    public RollBuilder evaluate(@NonNull List<RollBuilder> operands) throws ExpressionException {
        if (operands == null) {
            throw new NullPointerException("operands is marked non-null but is null");
        }
        return constants -> {
            List<Roll> rolls = RollBuilder.extendAllBuilder(operands, constants);
            ValidatorUtil.checkRollSize(this.getName(), rolls, 1, 1);
            Roll left = rolls.get(0);
            ImmutableList res = rolls.stream().mapToLong(result -> result.getElements().size()).sum() == 0L ? ImmutableList.of((Object)new RollElement("0", "")) : (ImmutableList)left.getElements().stream().collect(Collectors.groupingBy(RollElement::getColor)).entrySet().stream().map(e -> new RollElement(String.valueOf(((List)e.getValue()).size()), (String)e.getKey())).collect(ImmutableList.toImmutableList());
            return ImmutableList.of((Object)new Roll(Count.getLeftUnaryExpression(this.getName(), rolls), (ImmutableList<RollElement>)res, UniqueRandomElements.from(rolls), (ImmutableList<Roll>)ImmutableList.of((Object)left)));
        };
    }
}

