/*
 * Decompiled with CFR 0.152.
 */
package de.janno.evaluator.dice.operator.list;

import com.google.common.collect.ImmutableList;
import de.janno.evaluator.dice.ExpressionException;
import de.janno.evaluator.dice.Operator;
import de.janno.evaluator.dice.Roll;
import de.janno.evaluator.dice.RollBuilder;
import de.janno.evaluator.dice.RollElement;
import de.janno.evaluator.dice.UniqueRandomElements;
import de.janno.evaluator.dice.ValidatorUtil;
import de.janno.evaluator.dice.operator.OperatorOrder;
import java.util.List;
import lombok.NonNull;

public class EqualFilter
extends Operator {
    public EqualFilter() {
        super("==", Operator.OperatorType.BINARY, Operator.Associativity.LEFT, OperatorOrder.getOderNumberOf(EqualFilter.class));
    }

    @Override
    @NonNull
    public RollBuilder evaluate(@NonNull List<RollBuilder> operands) throws ExpressionException {
        if (operands == null) {
            throw new NullPointerException("operands is marked non-null but is null");
        }
        return constants -> {
            List<Roll> rolls = RollBuilder.extendAllBuilder(operands, constants);
            ValidatorUtil.checkRollSize(this.getName(), rolls, 2, 2);
            Roll left = rolls.get(0);
            Roll right = rolls.get(1);
            ValidatorUtil.checkContainsSingleElement(this.getName(), right, "right");
            ImmutableList diceResult = (ImmutableList)left.getElements().stream().filter(i -> ((RollElement)right.getElements().get(0)).equals(i)).collect(ImmutableList.toImmutableList());
            return ImmutableList.of((Object)new Roll(EqualFilter.getBinaryOperatorExpression(this.getName(), rolls), (ImmutableList<RollElement>)diceResult, UniqueRandomElements.from(rolls), (ImmutableList<Roll>)ImmutableList.of((Object)left, (Object)right)));
        };
    }
}

