/*
 * Decompiled with CFR 0.152.
 */
package de.janno.evaluator.dice.operator.list;

import com.google.common.collect.ImmutableList;
import de.janno.evaluator.dice.ExpressionException;
import de.janno.evaluator.dice.Operator;
import de.janno.evaluator.dice.Roll;
import de.janno.evaluator.dice.RollBuilder;
import de.janno.evaluator.dice.RollElement;
import de.janno.evaluator.dice.UniqueRandomElements;
import de.janno.evaluator.dice.ValidatorUtil;
import de.janno.evaluator.dice.operator.OperatorOrder;
import java.util.List;
import lombok.NonNull;

public class GreaterThanFilter
extends Operator {
    public GreaterThanFilter() {
        super(">", Operator.OperatorType.BINARY, Operator.Associativity.LEFT, OperatorOrder.getOderNumberOf(GreaterThanFilter.class));
    }

    @Override
    @NonNull
    public RollBuilder evaluate(@NonNull List<RollBuilder> operands) throws ExpressionException {
        if (operands == null) {
            throw new NullPointerException("operands is marked non-null but is null");
        }
        return constants -> {
            List<Roll> rolls = RollBuilder.extendAllBuilder(operands, constants);
            ValidatorUtil.checkRollSize(this.getName(), rolls, 2, 2);
            Roll left = rolls.get(0);
            Roll right = rolls.get(1);
            ValidatorUtil.checkContainsOnlyInteger(this.getName(), left, "left");
            int rightNumber = right.asInteger().orElseThrow(() -> ValidatorUtil.throwNotIntegerExpression(this.getName(), right, "right"));
            ImmutableList diceResult = (ImmutableList)left.getElements().stream().filter(i -> i.asInteger().isPresent() && i.asInteger().get() > rightNumber).collect(ImmutableList.toImmutableList());
            return ImmutableList.of((Object)new Roll(GreaterThanFilter.getBinaryOperatorExpression(this.getName(), rolls), (ImmutableList<RollElement>)diceResult, UniqueRandomElements.from(rolls), (ImmutableList<Roll>)ImmutableList.of((Object)left, (Object)right)));
        };
    }
}

