/*
 * Decompiled with CFR 0.152.
 */
package de.janno.evaluator.dice.operator.list;

import com.google.common.collect.ImmutableList;
import de.janno.evaluator.dice.ExpressionException;
import de.janno.evaluator.dice.Operator;
import de.janno.evaluator.dice.Roll;
import de.janno.evaluator.dice.RollBuilder;
import de.janno.evaluator.dice.RollElement;
import de.janno.evaluator.dice.UniqueRandomElements;
import de.janno.evaluator.dice.ValidatorUtil;
import de.janno.evaluator.dice.operator.OperatorOrder;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;

public class KeepHighest
extends Operator {
    public KeepHighest() {
        super("k", null, null, Operator.Associativity.LEFT, OperatorOrder.getOderNumberOf(KeepHighest.class));
    }

    @Override
    @NonNull
    public RollBuilder evaluate(@NonNull List<RollBuilder> operands) throws ExpressionException {
        if (operands == null) {
            throw new NullPointerException("operands is marked non-null but is null");
        }
        return constants -> {
            List<Roll> rolls = RollBuilder.extendAllBuilder(operands, constants);
            ValidatorUtil.checkRollSize(this.getName(), rolls, 2, 2);
            Roll left = rolls.get(0);
            Roll right = rolls.get(1);
            int rightNumber = right.asInteger().orElseThrow(() -> ValidatorUtil.throwNotIntegerExpression(this.getName(), right, "right"));
            ImmutableList keep = (ImmutableList)left.getElements().stream().collect(Collectors.groupingBy(RollElement::getColor)).values().stream().flatMap(cl -> cl.stream().sorted(Comparator.reverseOrder()).limit(rightNumber)).collect(ImmutableList.toImmutableList());
            return ImmutableList.of((Object)new Roll(KeepHighest.getBinaryOperatorExpression(this.getName(), rolls), (ImmutableList<RollElement>)keep, UniqueRandomElements.from(rolls), (ImmutableList<Roll>)ImmutableList.of((Object)left, (Object)right)));
        };
    }
}

