/*
 * Decompiled with CFR 0.152.
 */
package de.janno.evaluator.dice.operator.list;

import com.google.common.collect.ImmutableList;
import de.janno.evaluator.dice.ExpressionException;
import de.janno.evaluator.dice.Operator;
import de.janno.evaluator.dice.Roll;
import de.janno.evaluator.dice.RollBuilder;
import de.janno.evaluator.dice.RollElement;
import de.janno.evaluator.dice.UniqueRandomElements;
import de.janno.evaluator.dice.ValidatorUtil;
import de.janno.evaluator.dice.operator.OperatorOrder;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import lombok.NonNull;

public class RepeatList
extends Operator {
    public RepeatList() {
        super("r", null, null, Operator.Associativity.LEFT, OperatorOrder.getOderNumberOf(RepeatList.class));
    }

    @Override
    @NonNull
    public RollBuilder evaluate(@NonNull List<RollBuilder> operands) throws ExpressionException {
        if (operands == null) {
            throw new NullPointerException("operands is marked non-null but is null");
        }
        return constants -> {
            List<Roll> leftRolls = ((RollBuilder)operands.get(0)).extendRoll(constants);
            ValidatorUtil.checkRollSize(this.getName(), leftRolls, 1, 1);
            int left = leftRolls.get(0).asInteger().orElseThrow(() -> ValidatorUtil.throwNotIntegerExpression(this.getName(), (Roll)leftRolls.get(0), "left"));
            if (left > 10 || left < 1) {
                throw new ExpressionException(String.format("The number of repeat must between 1-10 but was %d", left));
            }
            RollBuilder right = (RollBuilder)operands.get(1);
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < left; ++i) {
                builder.addAll(right.extendRoll(new HashMap<String, Roll>(constants)));
            }
            ImmutableList rolls = builder.build();
            return ImmutableList.of((Object)new Roll(RepeatList.getBinaryOperatorExpression(this.getName(), (List<Roll>)rolls), (ImmutableList<RollElement>)((ImmutableList)rolls.stream().flatMap(r -> r.getElements().stream()).collect(ImmutableList.toImmutableList())), UniqueRandomElements.from((Collection<Roll>)rolls), (ImmutableList<Roll>)rolls));
        };
    }
}

