/*
 * Decompiled with CFR 0.152.
 */
package de.janno.evaluator.dice.operator.list;

import com.google.common.collect.ImmutableList;
import de.janno.evaluator.dice.ExpressionException;
import de.janno.evaluator.dice.Operator;
import de.janno.evaluator.dice.Roll;
import de.janno.evaluator.dice.RollBuilder;
import de.janno.evaluator.dice.RollElement;
import de.janno.evaluator.dice.UniqueRandomElements;
import de.janno.evaluator.dice.ValidatorUtil;
import de.janno.evaluator.dice.operator.OperatorOrder;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.NonNull;

public class Sum
extends Operator {
    public Sum() {
        super("=", Operator.OperatorType.UNARY, Operator.Associativity.LEFT, OperatorOrder.getOderNumberOf(Sum.class));
    }

    private static int sumExact(List<RollElement> elements) {
        return elements.stream().map(RollElement::asInteger).flatMap(Optional::stream).reduce(0, Math::addExact);
    }

    @Override
    @NonNull
    public RollBuilder evaluate(@NonNull List<RollBuilder> operands) throws ExpressionException {
        if (operands == null) {
            throw new NullPointerException("operands is marked non-null but is null");
        }
        return constants -> {
            List<Roll> rolls = RollBuilder.extendAllBuilder(operands, constants);
            ValidatorUtil.checkRollSize(this.getName(), rolls, 1, 1);
            Roll left = rolls.get(0);
            ValidatorUtil.checkContainsOnlyInteger(this.getName(), left, "left");
            ImmutableList res = (ImmutableList)left.getElements().stream().collect(Collectors.groupingBy(RollElement::getColor)).entrySet().stream().map(e -> new RollElement(String.valueOf(Sum.sumExact((List)e.getValue())), (String)e.getKey())).collect(ImmutableList.toImmutableList());
            return ImmutableList.of((Object)new Roll(Sum.getLeftUnaryExpression(this.getName(), rolls), (ImmutableList<RollElement>)res, UniqueRandomElements.from(rolls), (ImmutableList<Roll>)ImmutableList.of((Object)left)));
        };
    }
}

