/*
 * Decompiled with CFR 0.152.
 */
package de.janno.evaluator.dice.operator.math;

import com.google.common.collect.ImmutableList;
import de.janno.evaluator.dice.ExpressionException;
import de.janno.evaluator.dice.Operator;
import de.janno.evaluator.dice.Roll;
import de.janno.evaluator.dice.RollBuilder;
import de.janno.evaluator.dice.RollElement;
import de.janno.evaluator.dice.UniqueRandomElements;
import de.janno.evaluator.dice.ValidatorUtil;
import de.janno.evaluator.dice.operator.OperatorOrder;
import java.util.List;
import lombok.NonNull;

public final class Divide
extends Operator {
    public Divide() {
        super("/", Operator.OperatorType.BINARY, Operator.Associativity.LEFT, OperatorOrder.getOderNumberOf(Divide.class));
    }

    @Override
    @NonNull
    public RollBuilder evaluate(@NonNull List<RollBuilder> operands) throws ExpressionException {
        if (operands == null) {
            throw new NullPointerException("operands is marked non-null but is null");
        }
        return constants -> {
            List<Roll> rolls = RollBuilder.extendAllBuilder(operands, constants);
            ValidatorUtil.checkRollSize(this.getName(), rolls, 2, 2);
            Roll left = rolls.get(0);
            Roll right = rolls.get(1);
            ValidatorUtil.checkAllElementsAreSameColor(this.getName(), left, right);
            int leftNumber = left.asInteger().orElseThrow(() -> ValidatorUtil.throwNotIntegerExpression(this.getName(), left, "left"));
            int rightNumber = right.asInteger().orElseThrow(() -> ValidatorUtil.throwNotIntegerExpression(this.getName(), right, "right"));
            ImmutableList res = ImmutableList.of((Object)new RollElement(String.valueOf(Math.divideExact(leftNumber, rightNumber)), ((RollElement)left.getElements().get(0)).getColor()));
            return ImmutableList.of((Object)new Roll(Divide.getBinaryOperatorExpression(this.getName(), rolls), (ImmutableList<RollElement>)res, UniqueRandomElements.from(rolls), (ImmutableList<Roll>)ImmutableList.of((Object)left, (Object)right)));
        };
    }
}

