/*
 * Decompiled with CFR 0.152.
 */
package de.janno.evaluator.dice.operator.math;

import com.google.common.collect.ImmutableList;
import de.janno.evaluator.dice.ExpressionException;
import de.janno.evaluator.dice.Operator;
import de.janno.evaluator.dice.Roll;
import de.janno.evaluator.dice.RollBuilder;
import de.janno.evaluator.dice.RollElement;
import de.janno.evaluator.dice.UniqueRandomElements;
import de.janno.evaluator.dice.ValidatorUtil;
import de.janno.evaluator.dice.operator.OperatorOrder;
import java.util.List;
import lombok.NonNull;

public final class NegateOrNegativAppending
extends Operator {
    public NegateOrNegativAppending() {
        super("-", Operator.Associativity.RIGHT, OperatorOrder.getOderNumberOf(NegateOrNegativAppending.class), Operator.Associativity.LEFT, OperatorOrder.getOderNumberOf(NegateOrNegativAppending.class));
    }

    @Override
    @NonNull
    public RollBuilder evaluate(@NonNull List<RollBuilder> operands) throws ExpressionException {
        if (operands == null) {
            throw new NullPointerException("operands is marked non-null but is null");
        }
        return constants -> {
            List<Roll> rolls = RollBuilder.extendAllBuilder(operands, constants);
            ValidatorUtil.checkRollSize(this.getName(), rolls, 1, 2);
            if (rolls.size() == 1) {
                Roll right = rolls.get(0);
                ValidatorUtil.checkContainsOnlyInteger(this.getName(), right, "right");
                ImmutableList negated = (ImmutableList)right.getElements().stream().map(e -> new RollElement(String.valueOf(e.asInteger().orElseThrow() * -1), e.getColor())).collect(ImmutableList.toImmutableList());
                return ImmutableList.of((Object)new Roll(NegateOrNegativAppending.getRightUnaryExpression(this.getName(), rolls), (ImmutableList<RollElement>)negated, UniqueRandomElements.from(rolls), (ImmutableList<Roll>)ImmutableList.of((Object)right)));
            }
            Roll left = rolls.get(0);
            Roll right = rolls.get(1);
            ValidatorUtil.checkContainsOnlyInteger(this.getName(), right, "right");
            ImmutableList res = ImmutableList.builder().addAll(left.getElements()).addAll(right.getElements().stream().map(e -> new RollElement(String.valueOf(e.asInteger().orElseThrow() * -1), e.getColor())).toList()).build();
            return ImmutableList.of((Object)new Roll(NegateOrNegativAppending.getBinaryOperatorExpression(this.getName(), rolls), (ImmutableList<RollElement>)res, UniqueRandomElements.from(rolls), (ImmutableList<Roll>)ImmutableList.of((Object)left, (Object)right)));
        };
    }
}

