/*
 * Decompiled with CFR 0.152.
 */
package de.janno.evaluator.dice.random;

import com.google.common.annotations.VisibleForTesting;
import de.janno.evaluator.dice.ExpressionException;
import de.janno.evaluator.dice.random.NumberSupplier;
import de.janno.evaluator.dice.random.Sfc64Random;
import de.janno.evaluator.dice.random.ThreadLocalSfc64Random;
import java.util.random.RandomGenerator;

public class RandomNumberSupplier
implements NumberSupplier {
    private final RandomGenerator randomSource;

    public RandomNumberSupplier() {
        this.randomSource = new ThreadLocalSfc64Random();
    }

    @VisibleForTesting
    public RandomNumberSupplier(long seed) {
        this.randomSource = new Sfc64Random(seed);
    }

    @Override
    public int get(int minExcl, int maxIncl) throws ExpressionException {
        if (minExcl == Integer.MAX_VALUE) {
            throw new ExpressionException("Cannot give a random number for minExcl =%d".formatted(Integer.MAX_VALUE));
        }
        if (maxIncl == Integer.MAX_VALUE) {
            throw new ExpressionException("Cannot give a random number for maxIncl =%d".formatted(Integer.MAX_VALUE));
        }
        if (minExcl >= maxIncl) {
            throw new ExpressionException("Random number between %d (excl) and %d (incl) is not possible".formatted(minExcl, maxIncl));
        }
        if (minExcl + 1 == maxIncl) {
            return maxIncl;
        }
        return this.randomSource.nextInt(minExcl + 1, maxIncl + 1);
    }
}

