/*
 * Decompiled with CFR 0.152.
 */
package de.janno.evaluator.dice;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Resources;
import de.janno.evaluator.dice.BracketPair;
import de.janno.evaluator.dice.ExpressionException;
import de.janno.evaluator.dice.ExpressionPosition;
import de.janno.evaluator.dice.Function;
import de.janno.evaluator.dice.Operator;
import de.janno.evaluator.dice.Parameters;
import de.janno.evaluator.dice.RandomElement;
import de.janno.evaluator.dice.Roll;
import de.janno.evaluator.dice.RollBuilder;
import de.janno.evaluator.dice.RollContext;
import de.janno.evaluator.dice.RollElement;
import de.janno.evaluator.dice.RollResult;
import de.janno.evaluator.dice.Roller;
import de.janno.evaluator.dice.Token;
import de.janno.evaluator.dice.Tokenizer;
import de.janno.evaluator.dice.function.Cancel;
import de.janno.evaluator.dice.function.ColorFunction;
import de.janno.evaluator.dice.function.ColorOn;
import de.janno.evaluator.dice.function.ConcatFunction;
import de.janno.evaluator.dice.function.Double;
import de.janno.evaluator.dice.function.Explode;
import de.janno.evaluator.dice.function.GroupCount;
import de.janno.evaluator.dice.function.If;
import de.janno.evaluator.dice.function.IfEqual;
import de.janno.evaluator.dice.function.IfGreater;
import de.janno.evaluator.dice.function.IfIn;
import de.janno.evaluator.dice.function.IfLesser;
import de.janno.evaluator.dice.function.Max;
import de.janno.evaluator.dice.function.Min;
import de.janno.evaluator.dice.function.Replace;
import de.janno.evaluator.dice.function.SortAsc;
import de.janno.evaluator.dice.function.SortDesc;
import de.janno.evaluator.dice.function.Value;
import de.janno.evaluator.dice.operator.bool.AndBool;
import de.janno.evaluator.dice.operator.bool.EqualBool;
import de.janno.evaluator.dice.operator.bool.GreaterBool;
import de.janno.evaluator.dice.operator.bool.GreaterEqualBool;
import de.janno.evaluator.dice.operator.bool.InBool;
import de.janno.evaluator.dice.operator.bool.LesserBool;
import de.janno.evaluator.dice.operator.bool.LesserEqualBool;
import de.janno.evaluator.dice.operator.bool.NegateBool;
import de.janno.evaluator.dice.operator.bool.OrBool;
import de.janno.evaluator.dice.operator.die.Color;
import de.janno.evaluator.dice.operator.die.ExplodingAddDice;
import de.janno.evaluator.dice.operator.die.ExplodingDice;
import de.janno.evaluator.dice.operator.die.RegularDice;
import de.janno.evaluator.dice.operator.die.Reroll;
import de.janno.evaluator.dice.operator.die.Tag;
import de.janno.evaluator.dice.operator.list.AddToList;
import de.janno.evaluator.dice.operator.list.Concat;
import de.janno.evaluator.dice.operator.list.Count;
import de.janno.evaluator.dice.operator.list.EqualFilter;
import de.janno.evaluator.dice.operator.list.GreaterEqualThanFilter;
import de.janno.evaluator.dice.operator.list.GreaterThanFilter;
import de.janno.evaluator.dice.operator.list.KeepHighest;
import de.janno.evaluator.dice.operator.list.KeepLowest;
import de.janno.evaluator.dice.operator.list.LesserEqualThanFilter;
import de.janno.evaluator.dice.operator.list.LesserThanFilter;
import de.janno.evaluator.dice.operator.list.Repeat;
import de.janno.evaluator.dice.operator.list.RepeatList;
import de.janno.evaluator.dice.operator.list.Sum;
import de.janno.evaluator.dice.operator.math.DecimalDivide;
import de.janno.evaluator.dice.operator.math.IntegerDivide;
import de.janno.evaluator.dice.operator.math.Modulo;
import de.janno.evaluator.dice.operator.math.Multiply;
import de.janno.evaluator.dice.operator.math.NegateAddRemove;
import de.janno.evaluator.dice.random.NumberSupplier;
import de.janno.evaluator.dice.random.RandomNumberSupplier;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.NonNull;

public class DiceEvaluator {
    private static final int DEFAULT_MAX_NUMBER_OF_DICE = 1000;
    private static final int DEFAULT_MAX_NUMBER_OF_ELEMENTS = 10000;
    private static final boolean DEFAULT_KEEP_CHILDREN_ROLLS = true;
    private static final String SEPARATOR = ",";
    private static final String LEGACY_LIST_SEPARATOR = "/";
    private static final Pattern LIST_REGEX = Pattern.compile("(.+([%s%s].+)+)".formatted(",", "/"), 32);
    private final Tokenizer tokenizer;
    private final Parameters parameters;
    private final int maxNumberOfElements;
    private final boolean keepChildrenRolls;
    private final NumberSupplier defaultNumberSupplier;

    public DiceEvaluator() {
        this(new RandomNumberSupplier(), 1000, 10000, true);
    }

    public DiceEvaluator(@NonNull NumberSupplier numberSupplier, int maxNumberOfDice, int maxNumberOfElements, boolean keepChildrenRolls) {
        if (numberSupplier == null) {
            throw new NullPointerException("numberSupplier is marked non-null but is null");
        }
        this.maxNumberOfElements = maxNumberOfElements;
        this.keepChildrenRolls = keepChildrenRolls;
        this.defaultNumberSupplier = numberSupplier;
        this.parameters = Parameters.builder().expressionBracket(BracketPair.PARENTHESES).functionBracket(BracketPair.PARENTHESES).escapeBracket(BracketPair.APOSTROPHE).escapeBracket(BracketPair.BRACKETS).operators((Collection<? extends Operator>)ImmutableList.builder().add((Object)new RegularDice(maxNumberOfDice, maxNumberOfElements, keepChildrenRolls)).add((Object)new ExplodingDice(maxNumberOfDice, maxNumberOfElements, keepChildrenRolls)).add((Object)new ExplodingAddDice(maxNumberOfDice, maxNumberOfElements, keepChildrenRolls)).add((Object)new AddToList(maxNumberOfElements, keepChildrenRolls)).add((Object)new Concat(maxNumberOfElements, keepChildrenRolls)).add((Object)new Color(maxNumberOfElements, keepChildrenRolls)).add((Object)new Tag(maxNumberOfElements, keepChildrenRolls)).add((Object)new Sum(maxNumberOfElements, keepChildrenRolls)).add((Object)new Repeat(maxNumberOfElements, keepChildrenRolls)).add((Object)new RepeatList(maxNumberOfElements, keepChildrenRolls)).add((Object)new NegateAddRemove(maxNumberOfElements, keepChildrenRolls)).add((Object)new IntegerDivide(maxNumberOfElements, keepChildrenRolls)).add((Object)new DecimalDivide(maxNumberOfElements, keepChildrenRolls)).add((Object)new Multiply(maxNumberOfElements, keepChildrenRolls)).add((Object)new Modulo(maxNumberOfElements, keepChildrenRolls)).add((Object)new KeepHighest(maxNumberOfElements, keepChildrenRolls)).add((Object)new KeepLowest(maxNumberOfElements, keepChildrenRolls)).add((Object)new GreaterThanFilter(maxNumberOfElements, keepChildrenRolls)).add((Object)new LesserThanFilter(maxNumberOfElements, keepChildrenRolls)).add((Object)new GreaterEqualThanFilter(maxNumberOfElements, keepChildrenRolls)).add((Object)new LesserEqualThanFilter(maxNumberOfElements, keepChildrenRolls)).add((Object)new EqualFilter(maxNumberOfElements, keepChildrenRolls)).add((Object)new Count(maxNumberOfElements, keepChildrenRolls)).add((Object)new Reroll(maxNumberOfElements, keepChildrenRolls)).add((Object)new EqualBool(maxNumberOfElements, keepChildrenRolls)).add((Object)new GreaterBool(maxNumberOfElements, keepChildrenRolls)).add((Object)new GreaterEqualBool(maxNumberOfElements, keepChildrenRolls)).add((Object)new LesserBool(maxNumberOfElements, keepChildrenRolls)).add((Object)new LesserEqualBool(maxNumberOfElements, keepChildrenRolls)).add((Object)new InBool(maxNumberOfElements, keepChildrenRolls)).add((Object)new AndBool(maxNumberOfElements, keepChildrenRolls)).add((Object)new OrBool(maxNumberOfElements, keepChildrenRolls)).add((Object)new NegateBool(maxNumberOfElements, keepChildrenRolls)).build()).functions((Collection<? extends Function>)ImmutableList.builder().add((Object)new ColorFunction(maxNumberOfElements, keepChildrenRolls)).add((Object)new Value(maxNumberOfElements, keepChildrenRolls)).add((Object)new ConcatFunction(maxNumberOfElements, keepChildrenRolls)).add((Object)new SortAsc(maxNumberOfElements, keepChildrenRolls)).add((Object)new SortDesc(maxNumberOfElements, keepChildrenRolls)).add((Object)new Min(maxNumberOfElements, keepChildrenRolls)).add((Object)new Max(maxNumberOfElements, keepChildrenRolls)).add((Object)new Cancel(maxNumberOfElements, keepChildrenRolls)).add((Object)new Double(maxNumberOfElements, keepChildrenRolls)).add((Object)new IfEqual(maxNumberOfElements, keepChildrenRolls)).add((Object)new If(maxNumberOfElements, keepChildrenRolls)).add((Object)new IfGreater(maxNumberOfElements, keepChildrenRolls)).add((Object)new IfIn(maxNumberOfElements, keepChildrenRolls)).add((Object)new Replace(maxNumberOfElements, keepChildrenRolls)).add((Object)new ColorOn(maxNumberOfElements, keepChildrenRolls)).add((Object)new Explode(maxNumberOfElements, keepChildrenRolls)).add((Object)new IfLesser(maxNumberOfElements, keepChildrenRolls)).add((Object)new GroupCount(maxNumberOfElements, keepChildrenRolls)).build()).separator(SEPARATOR).build();
        this.tokenizer = new Tokenizer(this.parameters);
    }

    public static String getHelpText() {
        URL url = Resources.getResource((String)"help.md");
        try {
            return Resources.toString((URL)url, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static List<RollBuilder> reverse(Collection<RollBuilder> collection) {
        ArrayList<RollBuilder> result = new ArrayList<RollBuilder>(collection.size());
        for (RollBuilder t : collection) {
            result.addFirst(t);
        }
        return result;
    }

    private static boolean hasStackTokenPrecedence(Token currentToken, Token stackToken) {
        return stackToken.getOperator().isPresent() && (Operator.Associativity.LEFT.equals((Object)currentToken.getOperatorAssociativity().orElseThrow()) && currentToken.getOperatorPrecedence().orElseThrow() <= stackToken.getOperatorPrecedence().orElseThrow() || currentToken.getOperatorPrecedence().orElseThrow() < stackToken.getOperatorPrecedence().orElseThrow());
    }

    private Roller createRollSupplier(final String expression, final List<RollBuilder> rollBuilders) {
        return new Roller(){

            @Override
            @NonNull
            public RollResult roll() throws ExpressionException {
                return DiceEvaluator.this.rollWithNumberSupplier(expression, DiceEvaluator.this.defaultNumberSupplier, rollBuilders);
            }

            @Override
            @NonNull
            public RollResult roll(NumberSupplier numberSupplier) throws ExpressionException {
                return DiceEvaluator.this.rollWithNumberSupplier(expression, numberSupplier, rollBuilders);
            }
        };
    }

    private RollResult rollWithNumberSupplier(String expression, NumberSupplier numberSupplier, List<RollBuilder> rollBuilders) throws ExpressionException {
        RollContext rollContext = new RollContext(numberSupplier);
        ImmutableList rolls = RollBuilder.extendAllBuilder(rollBuilders, rollContext);
        Optional<String> expressionPrefix = rollContext.getExpressionPrefixString();
        if (expressionPrefix.isPresent()) {
            ImmutableList.Builder rollBuilder = ImmutableList.builder();
            for (Roll r : rolls) {
                String newExpressionString = "%s, %s".formatted(expressionPrefix.get(), r.getExpression());
                rollBuilder.add((Object)new Roll(newExpressionString, r.getElements(), r.getRandomElementsInRoll(), r.getChildrenRolls(), r.getExpressionPosition(), this.maxNumberOfElements, this.keepChildrenRolls));
            }
            rolls = rollBuilder.build();
        }
        return new RollResult(expression, rolls, rollContext.getAllRandomElements());
    }

    @NonNull
    private RollBuilder toValue(final @NonNull String literal, final @NonNull ExpressionPosition expressionPosition) {
        if (literal == null) {
            throw new NullPointerException("literal is marked non-null but is null");
        }
        if (expressionPosition == null) {
            throw new NullPointerException("expressionPosition is marked non-null but is null");
        }
        Matcher listMatcher = LIST_REGEX.matcher(literal);
        if (listMatcher.find()) {
            final List<String> list = Arrays.asList(listMatcher.group(1).split("[%s%s]".formatted(SEPARATOR, LEGACY_LIST_SEPARATOR)));
            return new RollBuilder(){

                @Override
                @NonNull
                public Optional<List<Roll>> extendRoll(@NonNull RollContext rollContext) throws ExpressionException {
                    if (rollContext == null) {
                        throw new NullPointerException("rollContext is marked non-null but is null");
                    }
                    return Optional.of(ImmutableList.of((Object)new Roll(this.toExpression(), (ImmutableList<RollElement>)((ImmutableList)list.stream().map(String::trim).map(s -> new RollElement((String)s, "", "")).collect(ImmutableList.toImmutableList())), (ImmutableList<RandomElement>)ImmutableList.of(), (ImmutableList<Roll>)ImmutableList.of(), expressionPosition, DiceEvaluator.this.maxNumberOfElements, DiceEvaluator.this.keepChildrenRolls)));
                }

                @Override
                @NonNull
                public String toExpression() {
                    return expressionPosition.toStringWithExtension();
                }
            };
        }
        return new RollBuilder(){

            @Override
            @NonNull
            public Optional<List<Roll>> extendRoll(@NonNull RollContext rollContext) throws ExpressionException {
                if (rollContext == null) {
                    throw new NullPointerException("rollContext is marked non-null but is null");
                }
                Optional<Roll> variableRoll = rollContext.getVariable(literal);
                if (variableRoll.isPresent()) {
                    Roll variableValue = variableRoll.get();
                    Roll replacedValue = new Roll(this.toExpression(), variableValue.getElements(), variableValue.getRandomElementsInRoll(), variableValue.getChildrenRolls(), expressionPosition, DiceEvaluator.this.maxNumberOfElements, DiceEvaluator.this.keepChildrenRolls);
                    return Optional.of(ImmutableList.of((Object)replacedValue));
                }
                if (literal.isEmpty()) {
                    return Optional.of(ImmutableList.of((Object)new Roll(this.toExpression(), (ImmutableList<RollElement>)ImmutableList.of(), (ImmutableList<RandomElement>)ImmutableList.of(), (ImmutableList<Roll>)ImmutableList.of(), expressionPosition, DiceEvaluator.this.maxNumberOfElements, DiceEvaluator.this.keepChildrenRolls)));
                }
                return Optional.of(ImmutableList.of((Object)new Roll(this.toExpression(), (ImmutableList<RollElement>)ImmutableList.of((Object)new RollElement(literal, "", "")), (ImmutableList<RandomElement>)ImmutableList.of(), (ImmutableList<Roll>)ImmutableList.of(), expressionPosition, DiceEvaluator.this.maxNumberOfElements, DiceEvaluator.this.keepChildrenRolls)));
            }

            @Override
            @NonNull
            public String toExpression() {
                return expressionPosition.toStringWithExtension();
            }
        };
    }

    private void processTokenToValues(Deque<RollBuilder> values, Token token) throws ExpressionException {
        if (token.getLiteral().isPresent()) {
            String literal = token.getLiteral().get();
            values.push(this.toValue(literal, token.getExpressionPosition()));
        } else if (token.getOperator().isPresent()) {
            Operator operator = token.getOperator().get();
            int argumentCount = token.getOperatorType().orElseThrow().argumentCount;
            if (values.size() < argumentCount) {
                throw new ExpressionException("Not enough values, %s needs %d".formatted(operator.getName(), argumentCount), token.getExpressionPosition());
            }
            values.push(operator.evaluate(this.getArguments(values, argumentCount), token.getExpressionPosition()));
        } else {
            throw new ExpressionException(token.toString(), token.getExpressionPosition());
        }
    }

    private void doFunction(Deque<RollBuilder> values, Function function, int argumentCount, ExpressionPosition expressionPosition) throws ExpressionException {
        RollBuilder res = function.evaluate(this.getArguments(values, argumentCount), expressionPosition);
        values.push(res);
    }

    private List<RollBuilder> getArguments(Deque<RollBuilder> values, int argumentCount) {
        ArrayList<RollBuilder> result = new ArrayList<RollBuilder>(argumentCount);
        for (int i = 0; i < argumentCount; ++i) {
            result.addFirst(values.pop());
        }
        return result;
    }

    private boolean isFunctionOpenBracket(Token token) {
        if (token == null || !token.isOpenBracket()) {
            return false;
        }
        return this.parameters.getFunctionBrackets().contains(token.getBrackets().orElseThrow());
    }

    public boolean expressionContainsOperatorOrFunction(String expression) {
        return this.tokenizer.expressionContainsOperatorOrFunction(expression);
    }

    public RollResult evaluate(String expression) throws ExpressionException {
        return this.buildRollSupplier(expression).roll();
    }

    public Roller buildRollSupplier(String inputExpression) throws ExpressionException {
        final String expression = inputExpression.trim();
        if (Strings.isNullOrEmpty((String)expression)) {
            return new Roller(){

                @Override
                @NonNull
                public RollResult roll() {
                    return new RollResult(expression, (ImmutableList<Roll>)ImmutableList.of(), (ImmutableList<RandomElement>)ImmutableList.of());
                }

                @Override
                @NonNull
                public RollResult roll(NumberSupplier numberSupplier) {
                    return new RollResult(expression, (ImmutableList<Roll>)ImmutableList.of(), (ImmutableList<RandomElement>)ImmutableList.of());
                }
            };
        }
        List<Token> tokens = this.tokenizer.tokenize(expression);
        ArrayDeque<RollBuilder> values = new ArrayDeque<RollBuilder>(tokens.size());
        LinkedList<Token> stack = new LinkedList<Token>();
        ArrayDeque<Integer> previousValuesSize = new ArrayDeque<Integer>(tokens.size());
        Optional<Token> previous = Optional.empty();
        for (Token token : tokens) {
            if (previous.flatMap(Token::getFunction).isPresent() && !this.isFunctionOpenBracket(token)) {
                String functionName = previous.flatMap(Token::getFunction).map(Function::getName).orElseThrow();
                String allowedBrackets = this.parameters.getFunctionBrackets().stream().map(BracketPair::getOpen).collect(Collectors.joining(" or "));
                throw new ExpressionException("A function, in this case '%s', must be followed a open function bracket: %s".formatted(functionName, allowedBrackets), token.getExpressionPosition());
            }
            if (token.getBrackets().isPresent() && token.isOpenBracket()) {
                stack.push(token);
                if (previous.flatMap(Token::getFunction).isPresent()) {
                    if (!this.parameters.getFunctionBrackets().contains(token.getBrackets().get())) {
                        throw new ExpressionException("Invalid bracket after function: %s".formatted(token), token.getExpressionPosition());
                    }
                } else if (!this.parameters.getExpressionBrackets().contains(token.getBrackets().get())) {
                    throw new ExpressionException("Invalid bracket in expression: %s".formatted(token), token.getExpressionPosition());
                }
            } else if (token.isCloseBracket()) {
                if (previous.isEmpty()) {
                    throw new ExpressionException("expression can't start with a close bracket", token.getExpressionPosition());
                }
                if (((Token)previous.get()).isOpenBracket()) {
                    throw new ExpressionException("empty brackets are not allowed", token.getExpressionPosition());
                }
                if (previous.map(Token::isSeparator).get().booleanValue()) {
                    throw new ExpressionException("argument is missing", token.getExpressionPosition());
                }
                BracketPair brackets = token.getBrackets().get();
                boolean openBracketFound = false;
                while (!stack.isEmpty() && !openBracketFound) {
                    Token stackToken = (Token)stack.pop();
                    if (stackToken.getBrackets().isPresent() && stackToken.isOpenBracket()) {
                        if (stackToken.getBrackets().get().equals(brackets)) {
                            openBracketFound = true;
                            continue;
                        }
                        throw new ExpressionException("Invalid parenthesis match %s%s".formatted(stackToken.getBrackets().get().getOpen(), brackets.getClose()), token.getExpressionPosition());
                    }
                    this.processTokenToValues(values, stackToken);
                }
                if (!openBracketFound) {
                    throw new ExpressionException("Parentheses mismatched", token.getExpressionPosition());
                }
                if (!stack.isEmpty() && ((Token)stack.peek()).getFunction().isPresent()) {
                    int argumentCount = values.size() - (Integer)previousValuesSize.pop();
                    Token functionToken = (Token)stack.pop();
                    this.doFunction(values, functionToken.getFunction().orElseThrow(), argumentCount, functionToken.getExpressionPosition());
                }
            } else if (token.isSeparator()) {
                if (previous.isEmpty()) {
                    throw new ExpressionException("expression can't start with a separator", token.getExpressionPosition());
                }
                if (((Token)previous.get()).isOpenBracket() || ((Token)previous.get()).isSeparator()) {
                    throw new ExpressionException("A separator can't be followed by another separator or open bracket", token.getExpressionPosition());
                }
                boolean openBracketOnStackReached = false;
                while (!stack.isEmpty() && !openBracketOnStackReached) {
                    if (((Token)stack.peek()).isOpenBracket()) {
                        openBracketOnStackReached = true;
                        if (stack.size() >= 2 && !((Token)stack.get(1)).getFunction().isEmpty()) continue;
                        throw new ExpressionException("Separator '%s' in bracket '%s' without leading function is not allowed".formatted(this.parameters.getSeparator(), this.parameters.getExpressionBrackets().stream().map(Object::toString).collect(Collectors.joining(SEPARATOR))), token.getExpressionPosition());
                    }
                    Token stackToken = (Token)stack.pop();
                    this.processTokenToValues(values, stackToken);
                }
            } else if (token.getFunction().isPresent()) {
                stack.push(token);
                previousValuesSize.push(values.size());
            } else if (token.getOperator().isPresent()) {
                while (!stack.isEmpty() && DiceEvaluator.hasStackTokenPrecedence(token, (Token)stack.peek())) {
                    this.processTokenToValues(values, (Token)stack.pop());
                }
                stack.push(token);
            } else if (token.getLiteral().isPresent()) {
                if (previous.flatMap(Token::getLiteral).isPresent() && !stack.isEmpty()) {
                    if (!((Token)stack.peek()).isOpenBracket()) {
                        this.processTokenToValues(values, (Token)stack.pop());
                    } else {
                        throw new ExpressionException("All brackets need to be closed be for starting a new expression or missing ','", token.getExpressionPosition());
                    }
                }
                this.processTokenToValues(values, token);
            } else {
                throw new IllegalStateException("Unknown Token: %s".formatted(token));
            }
            previous = Optional.of(token);
        }
        for (Token stackToken : stack) {
            if (stackToken.isOpenBracket() || stackToken.isCloseBracket()) {
                throw new ExpressionException("Parentheses mismatched", stackToken.getExpressionPosition());
            }
            this.processTokenToValues(values, stackToken);
        }
        return this.createRollSupplier(expression, DiceEvaluator.reverse(values));
    }
}

