/*
 * Decompiled with CFR 0.152.
 */
package de.janno.evaluator.dice;

import com.google.common.collect.ImmutableList;
import de.janno.evaluator.dice.DieId;
import de.janno.evaluator.dice.ExpressionException;
import de.janno.evaluator.dice.RandomElement;
import de.janno.evaluator.dice.RollElement;
import de.janno.evaluator.dice.RollId;
import de.janno.evaluator.dice.random.NumberSupplier;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;

public final class DiceHelper {
    @NonNull
    public static ImmutableList<RandomElement> explodingDice(int number, int sides, @NonNull NumberSupplier numberSupplier, @NonNull RollId rollId, int maxNumberOfElements, String expression) throws ExpressionException {
        if (numberSupplier == null) {
            throw new NullPointerException("numberSupplier is marked non-null but is null");
        }
        if (rollId == null) {
            throw new NullPointerException("rollId is marked non-null but is null");
        }
        if (sides == 0) {
            return ImmutableList.of();
        }
        if (sides < 0) {
            throw new ExpressionException("Sides of dice to roll must be positive", rollId.getExpressionPosition());
        }
        ArrayList<RandomElement> resultBuilder = new ArrayList<RandomElement>();
        for (int i = 0; i < number; ++i) {
            resultBuilder.addAll(DiceHelper.rollExplodingDie(sides, numberSupplier, rollId, i, maxNumberOfElements, expression));
            if (resultBuilder.size() <= maxNumberOfElements) continue;
            throw new ExpressionException("To many elements in roll '%s', max is %d but there where %d".formatted(expression, maxNumberOfElements, resultBuilder.size()), rollId.getExpressionPosition());
        }
        return ImmutableList.copyOf(resultBuilder);
    }

    private static List<RandomElement> rollExplodingDie(int sides, NumberSupplier numberSupplier, RollId rollId, int index, int maxNumberOfElements, String expression) throws ExpressionException {
        ArrayList<RandomElement> resultBuilder = new ArrayList<RandomElement>();
        int rerollCounter = 0;
        RandomElement currentRoll = DiceHelper.rollDie(sides, numberSupplier, rollId, index, rerollCounter++);
        String rerollValue = String.valueOf(sides);
        resultBuilder.add(currentRoll);
        while (currentRoll.getRollElement().getValue().equals(rerollValue)) {
            currentRoll = DiceHelper.rollDie(sides, numberSupplier, rollId, index, rerollCounter++);
            resultBuilder.add(currentRoll);
            if (resultBuilder.size() <= maxNumberOfElements) continue;
            throw new ExpressionException("To many elements in roll '%s', max is %d but there where %d".formatted(expression, maxNumberOfElements, resultBuilder.size()), rollId.getExpressionPosition());
        }
        return ImmutableList.copyOf(resultBuilder);
    }

    @NonNull
    public static ImmutableList<RandomElement> rollDice(int number, int sides, @NonNull NumberSupplier numberSupplier, @NonNull RollId rollId) throws ExpressionException {
        if (numberSupplier == null) {
            throw new NullPointerException("numberSupplier is marked non-null but is null");
        }
        if (rollId == null) {
            throw new NullPointerException("rollId is marked non-null but is null");
        }
        if (sides == 0) {
            return ImmutableList.of();
        }
        if (sides < 0) {
            throw new ExpressionException("Sides of dice to roll must be positive", rollId.getExpressionPosition());
        }
        ImmutableList.Builder randomElementBuilder = ImmutableList.builder();
        for (int i = 0; i < number; ++i) {
            randomElementBuilder.add((Object)DiceHelper.rollDie(sides, numberSupplier, rollId, i, 0));
        }
        return randomElementBuilder.build();
    }

    private static RandomElement rollDie(int sides, @NonNull NumberSupplier numberSupplier, @NonNull RollId rollId, int index, int reroll) throws ExpressionException {
        if (numberSupplier == null) {
            throw new NullPointerException("numberSupplier is marked non-null but is null");
        }
        if (rollId == null) {
            throw new NullPointerException("rollId is marked non-null but is null");
        }
        DieId dieId = DieId.of(rollId, index, reroll);
        int numberSupplierValue = numberSupplier.get(0, sides, dieId);
        return new RandomElement(new RollElement(String.valueOf(numberSupplierValue), "", ""), 1, sides, dieId, numberSupplierValue);
    }

    @NonNull
    public static RandomElement pickOneOf(List<RollElement> list, @NonNull NumberSupplier numberSupplier, @NonNull DieId dieId) throws ExpressionException {
        if (numberSupplier == null) {
            throw new NullPointerException("numberSupplier is marked non-null but is null");
        }
        if (dieId == null) {
            throw new NullPointerException("dieId is marked non-null but is null");
        }
        int numberSupplierValue = numberSupplier.get(0, list.size(), dieId);
        return new RandomElement(list.get(numberSupplierValue - 1), (ImmutableList<String>)((ImmutableList)list.stream().map(RollElement::getValue).collect(ImmutableList.toImmutableList())), dieId, numberSupplierValue);
    }
}

