/*
 * Decompiled with CFR 0.152.
 */
package de.janno.evaluator.dice;

import de.janno.evaluator.dice.ExpressionPosition;
import de.janno.evaluator.dice.RollId;
import lombok.Generated;
import lombok.NonNull;

public final class DieId
implements Comparable<DieId> {
    @NonNull
    private final RollId rollId;
    private final int dieIndex;
    private final int reroll;

    public static DieId of(int expressionPositionStartInc, String value, int reEvaluateCounter, int dieIndex, int reroll) {
        return new DieId(RollId.of(ExpressionPosition.of(expressionPositionStartInc, value), reEvaluateCounter), dieIndex, reroll);
    }

    public String toString() {
        return String.valueOf(this.rollId) + "i" + this.dieIndex + "r" + this.reroll;
    }

    @Override
    public int compareTo(DieId o) {
        if (!this.rollId.equals(o.getRollId())) {
            return this.rollId.compareTo(o.getRollId());
        }
        if (this.dieIndex != o.getDieIndex()) {
            return Integer.compare(this.dieIndex, o.getDieIndex());
        }
        return Integer.compare(this.reroll, o.reroll);
    }

    @Generated
    private DieId(@NonNull RollId rollId, int dieIndex, int reroll) {
        if (rollId == null) {
            throw new NullPointerException("rollId is marked non-null but is null");
        }
        this.rollId = rollId;
        this.dieIndex = dieIndex;
        this.reroll = reroll;
    }

    @Generated
    public static DieId of(@NonNull RollId rollId, int dieIndex, int reroll) {
        if (rollId == null) {
            throw new NullPointerException("rollId is marked non-null but is null");
        }
        return new DieId(rollId, dieIndex, reroll);
    }

    @NonNull
    @Generated
    public RollId getRollId() {
        return this.rollId;
    }

    @Generated
    public int getDieIndex() {
        return this.dieIndex;
    }

    @Generated
    public int getReroll() {
        return this.reroll;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DieId)) {
            return false;
        }
        DieId other = (DieId)o;
        if (this.getDieIndex() != other.getDieIndex()) {
            return false;
        }
        if (this.getReroll() != other.getReroll()) {
            return false;
        }
        RollId this$rollId = this.getRollId();
        RollId other$rollId = other.getRollId();
        return !(this$rollId == null ? other$rollId != null : !((Object)this$rollId).equals(other$rollId));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getDieIndex();
        result = result * 59 + this.getReroll();
        RollId $rollId = this.getRollId();
        result = result * 59 + ($rollId == null ? 43 : ((Object)$rollId).hashCode());
        return result;
    }
}

