/*
 * Decompiled with CFR 0.152.
 */
package de.janno.evaluator.dice;

import com.google.common.base.Joiner;
import javax.annotation.Nullable;
import lombok.Generated;
import lombok.NonNull;

public final class ExpressionPosition
implements Comparable<ExpressionPosition> {
    private final int startInc;
    @NonNull
    private final String value;
    @Nullable
    private final String leftExtension;
    @Nullable
    private final String rightExtension;

    public static ExpressionPosition of(int startInc, String value) {
        return new ExpressionPosition(startInc, value, null, null);
    }

    public ExpressionPosition extendLeft(String leftValue) {
        return new ExpressionPosition(this.startInc, this.value, leftValue, this.rightExtension);
    }

    public ExpressionPosition extendRight(String rightValue) {
        return new ExpressionPosition(this.startInc, this.value, this.leftExtension, rightValue);
    }

    public String toString() {
        return this.startInc + this.value;
    }

    public String toStringWithExtension() {
        return Joiner.on((String)"").skipNulls().join((Object)this.leftExtension, (Object)this.value, new Object[]{this.rightExtension});
    }

    @Override
    public int compareTo(ExpressionPosition o) {
        return Integer.compare(this.startInc, o.startInc);
    }

    @Generated
    public ExpressionPosition(int startInc, @NonNull String value, @Nullable String leftExtension, @Nullable String rightExtension) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.startInc = startInc;
        this.value = value;
        this.leftExtension = leftExtension;
        this.rightExtension = rightExtension;
    }

    @Generated
    public int getStartInc() {
        return this.startInc;
    }

    @NonNull
    @Generated
    public String getValue() {
        return this.value;
    }

    @Nullable
    @Generated
    public String getLeftExtension() {
        return this.leftExtension;
    }

    @Nullable
    @Generated
    public String getRightExtension() {
        return this.rightExtension;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExpressionPosition)) {
            return false;
        }
        ExpressionPosition other = (ExpressionPosition)o;
        if (this.getStartInc() != other.getStartInc()) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$leftExtension = this.getLeftExtension();
        String other$leftExtension = other.getLeftExtension();
        if (this$leftExtension == null ? other$leftExtension != null : !this$leftExtension.equals(other$leftExtension)) {
            return false;
        }
        String this$rightExtension = this.getRightExtension();
        String other$rightExtension = other.getRightExtension();
        return !(this$rightExtension == null ? other$rightExtension != null : !this$rightExtension.equals(other$rightExtension));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getStartInc();
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $leftExtension = this.getLeftExtension();
        result = result * 59 + ($leftExtension == null ? 43 : $leftExtension.hashCode());
        String $rightExtension = this.getRightExtension();
        result = result * 59 + ($rightExtension == null ? 43 : $rightExtension.hashCode());
        return result;
    }
}

