/*
 * Decompiled with CFR 0.152.
 */
package de.janno.evaluator.dice;

import de.janno.evaluator.dice.ExpressionException;
import de.janno.evaluator.dice.ExpressionPosition;
import de.janno.evaluator.dice.RollBuilder;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;

public abstract class Function {
    protected final int maxNumberOfElements;
    protected final boolean keepChildrenRolls;
    @NonNull
    private final String name;
    private final int minArgumentCount;
    private final int maxArgumentCount;

    public Function(@NonNull String name, int argumentCount, int maxNumberOfElements, boolean keepChildrenRolls) {
        this(name, argumentCount, argumentCount, maxNumberOfElements, keepChildrenRolls);
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
    }

    public Function(@NonNull String name, int minArgumentCount, int maxArgumentCount, int maxNumberOfElements, boolean keepChildrenRolls) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (minArgumentCount < 0 || minArgumentCount > maxArgumentCount) {
            throw new IllegalArgumentException("Invalid argument count");
        }
        this.name = name;
        this.minArgumentCount = minArgumentCount;
        this.maxArgumentCount = maxArgumentCount;
        this.maxNumberOfElements = maxNumberOfElements;
        this.keepChildrenRolls = keepChildrenRolls;
    }

    protected static String getExpression(ExpressionPosition expressionPosition, List<RollBuilder> arguments) {
        return "%s%s".formatted(expressionPosition.toStringWithExtension(), arguments.stream().map(RollBuilder::toExpression).collect(Collectors.joining(",")));
    }

    @NonNull
    public abstract RollBuilder evaluate(@NonNull List<RollBuilder> var1, @NonNull ExpressionPosition var2) throws ExpressionException;

    @Generated
    public int getMaxNumberOfElements() {
        return this.maxNumberOfElements;
    }

    @Generated
    public boolean isKeepChildrenRolls() {
        return this.keepChildrenRolls;
    }

    @NonNull
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public int getMinArgumentCount() {
        return this.minArgumentCount;
    }

    @Generated
    public int getMaxArgumentCount() {
        return this.maxArgumentCount;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Function)) {
            return false;
        }
        Function other = (Function)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxNumberOfElements() != other.getMaxNumberOfElements()) {
            return false;
        }
        if (this.isKeepChildrenRolls() != other.isKeepChildrenRolls()) {
            return false;
        }
        if (this.getMinArgumentCount() != other.getMinArgumentCount()) {
            return false;
        }
        if (this.getMaxArgumentCount() != other.getMaxArgumentCount()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Function;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaxNumberOfElements();
        result = result * 59 + (this.isKeepChildrenRolls() ? 79 : 97);
        result = result * 59 + this.getMinArgumentCount();
        result = result * 59 + this.getMaxArgumentCount();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Function(maxNumberOfElements=" + this.getMaxNumberOfElements() + ", keepChildrenRolls=" + this.isKeepChildrenRolls() + ", name=" + this.getName() + ", minArgumentCount=" + this.getMinArgumentCount() + ", maxArgumentCount=" + this.getMaxArgumentCount() + ")";
    }
}

