/*
 * Decompiled with CFR 0.152.
 */
package de.janno.evaluator.dice;

import de.janno.evaluator.dice.ExpressionException;
import de.janno.evaluator.dice.ExpressionPosition;
import de.janno.evaluator.dice.RollBuilder;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;

public abstract class Operator {
    protected final int maxNumberOfElements;
    protected final boolean keepChildrenRolls;
    @NonNull
    private final String name;
    private final Integer unaryPrecedence;
    private final Integer binaryPrecedence;
    private final Associativity unaryAssociativity;
    private final Associativity binaryAssociativity;

    public Operator(@NonNull String name, OperatorType operatorType, @NonNull Associativity associativity, int precedence, int maxNumberOfElements, boolean keepChildrenRolls) {
        this(name, Operator.getUnaryAssociativity(operatorType, associativity), Operator.getUnaryPrecedence(operatorType, precedence), Operator.getBinaryAssociativity(operatorType, associativity), Operator.getBinaryPrecedence(operatorType, precedence), maxNumberOfElements, keepChildrenRolls);
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (associativity == null) {
            throw new NullPointerException("associativity is marked non-null but is null");
        }
    }

    public Operator(@NonNull String name, Associativity unaryAssociativity, Integer unaryPrecedence, Associativity binaryAssociativity, Integer binaryPrecedence, int maxNumberOfElements, boolean keepChildrenRolls) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (unaryAssociativity == null && binaryAssociativity == null) {
            throw new IllegalArgumentException("The operant %s need at least on associativity".formatted(name));
        }
        this.name = name;
        this.unaryAssociativity = unaryAssociativity;
        this.binaryAssociativity = binaryAssociativity;
        this.unaryPrecedence = unaryPrecedence;
        this.binaryPrecedence = binaryPrecedence;
        this.maxNumberOfElements = maxNumberOfElements;
        this.keepChildrenRolls = keepChildrenRolls;
    }

    private static Associativity getUnaryAssociativity(OperatorType operatorType, @NonNull Associativity associativity) {
        if (associativity == null) {
            throw new NullPointerException("associativity is marked non-null but is null");
        }
        if (operatorType == OperatorType.UNARY) {
            return associativity;
        }
        return null;
    }

    private static Associativity getBinaryAssociativity(OperatorType operatorType, @NonNull Associativity associativity) {
        if (associativity == null) {
            throw new NullPointerException("associativity is marked non-null but is null");
        }
        if (operatorType == OperatorType.BINARY) {
            return associativity;
        }
        return null;
    }

    private static Integer getUnaryPrecedence(OperatorType operatorType, int precedence) {
        if (operatorType == OperatorType.UNARY) {
            return precedence;
        }
        return null;
    }

    private static Integer getBinaryPrecedence(OperatorType operatorType, int precedence) {
        if (operatorType == OperatorType.BINARY) {
            return precedence;
        }
        return null;
    }

    private static <T> Optional<T> getIndexIfExists(List<T> list, int index) {
        if (list.size() <= index) {
            return Optional.empty();
        }
        return Optional.ofNullable(list.get(index));
    }

    protected static String getBinaryOperatorExpression(ExpressionPosition expressionPosition, List<RollBuilder> operands) {
        String left = Operator.getIndexIfExists(operands, 0).map(RollBuilder::toExpression).orElse("");
        String right = Operator.getIndexIfExists(operands, 1).map(RollBuilder::toExpression).orElse("");
        return String.format("%s%s%s", left, expressionPosition.toStringWithExtension(), right);
    }

    protected static String getLeftUnaryExpression(ExpressionPosition expressionPosition, List<RollBuilder> operands) {
        String left = Operator.getIndexIfExists(operands, 0).map(RollBuilder::toExpression).orElse("");
        return String.format("%s%s", left, expressionPosition.toStringWithExtension());
    }

    protected static String getRightUnaryExpression(ExpressionPosition expressionPosition, List<RollBuilder> operands) {
        String right = Operator.getIndexIfExists(operands, 0).map(RollBuilder::toExpression).orElse("");
        return String.format("%s%s", expressionPosition.toStringWithExtension(), right);
    }

    @NonNull
    public abstract RollBuilder evaluate(@NonNull List<RollBuilder> var1, @NonNull ExpressionPosition var2) throws ExpressionException;

    public boolean supportUnaryOperation() {
        return this.unaryAssociativity != null;
    }

    public boolean supportBinaryOperation() {
        return this.binaryAssociativity != null;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public Associativity getAssociativityForOperantType(OperatorType operatorType) {
        if (operatorType == OperatorType.UNARY && this.unaryAssociativity != null) {
            return this.unaryAssociativity;
        }
        if (operatorType == OperatorType.BINARY && this.binaryAssociativity != null) {
            return this.binaryAssociativity;
        }
        return null;
    }

    public int getPrecedenceForOperantType(OperatorType operatorType) {
        if (operatorType == OperatorType.UNARY && this.unaryPrecedence != null) {
            return this.unaryPrecedence;
        }
        if (operatorType == OperatorType.BINARY && this.binaryPrecedence != null) {
            return this.binaryPrecedence;
        }
        throw new IllegalStateException("'%s' has no precedence for a operand type of %s".formatted(new Object[]{this.getName(), operatorType}));
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Operator)) {
            return false;
        }
        Operator other = (Operator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.maxNumberOfElements != other.maxNumberOfElements) {
            return false;
        }
        if (this.keepChildrenRolls != other.keepChildrenRolls) {
            return false;
        }
        Integer this$unaryPrecedence = this.unaryPrecedence;
        Integer other$unaryPrecedence = other.unaryPrecedence;
        if (this$unaryPrecedence == null ? other$unaryPrecedence != null : !((Object)this$unaryPrecedence).equals(other$unaryPrecedence)) {
            return false;
        }
        Integer this$binaryPrecedence = this.binaryPrecedence;
        Integer other$binaryPrecedence = other.binaryPrecedence;
        if (this$binaryPrecedence == null ? other$binaryPrecedence != null : !((Object)this$binaryPrecedence).equals(other$binaryPrecedence)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Associativity this$unaryAssociativity = this.unaryAssociativity;
        Associativity other$unaryAssociativity = other.unaryAssociativity;
        if (this$unaryAssociativity == null ? other$unaryAssociativity != null : !((Object)((Object)this$unaryAssociativity)).equals((Object)other$unaryAssociativity)) {
            return false;
        }
        Associativity this$binaryAssociativity = this.binaryAssociativity;
        Associativity other$binaryAssociativity = other.binaryAssociativity;
        return !(this$binaryAssociativity == null ? other$binaryAssociativity != null : !((Object)((Object)this$binaryAssociativity)).equals((Object)other$binaryAssociativity));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Operator;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.maxNumberOfElements;
        result = result * 59 + (this.keepChildrenRolls ? 79 : 97);
        Integer $unaryPrecedence = this.unaryPrecedence;
        result = result * 59 + ($unaryPrecedence == null ? 43 : ((Object)$unaryPrecedence).hashCode());
        Integer $binaryPrecedence = this.binaryPrecedence;
        result = result * 59 + ($binaryPrecedence == null ? 43 : ((Object)$binaryPrecedence).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Associativity $unaryAssociativity = this.unaryAssociativity;
        result = result * 59 + ($unaryAssociativity == null ? 43 : ((Object)((Object)$unaryAssociativity)).hashCode());
        Associativity $binaryAssociativity = this.binaryAssociativity;
        result = result * 59 + ($binaryAssociativity == null ? 43 : ((Object)((Object)$binaryAssociativity)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Operator(maxNumberOfElements=" + this.maxNumberOfElements + ", keepChildrenRolls=" + this.keepChildrenRolls + ", name=" + this.getName() + ", unaryPrecedence=" + this.unaryPrecedence + ", binaryPrecedence=" + this.binaryPrecedence + ", unaryAssociativity=" + String.valueOf((Object)this.unaryAssociativity) + ", binaryAssociativity=" + String.valueOf((Object)this.binaryAssociativity) + ")";
    }

    public static enum OperatorType {
        UNARY(1),
        BINARY(2);

        public final int argumentCount;

        private OperatorType(int argumentCount) {
            this.argumentCount = argumentCount;
        }

        public static OperatorType of(int argumentCount) {
            if (argumentCount == 1) {
                return UNARY;
            }
            if (argumentCount == 2) {
                return BINARY;
            }
            throw new IllegalArgumentException("OperatorType must have a argumentCount of 1 or 2");
        }
    }

    public static enum Associativity {
        LEFT,
        RIGHT;

    }
}

