/*
 * Decompiled with CFR 0.152.
 */
package de.janno.evaluator.dice;

import com.google.common.collect.ImmutableList;
import de.janno.evaluator.dice.DieId;
import de.janno.evaluator.dice.DieIdAndValue;
import de.janno.evaluator.dice.RollElement;
import javax.annotation.Nullable;
import lombok.Generated;
import lombok.NonNull;

public final class RandomElement {
    @NonNull
    private final RollElement rollElement;
    @Nullable
    private final ImmutableList<String> randomSelectedFrom;
    private final int numberSupplierValue;
    @NonNull
    private final DieId dieId;
    @Nullable
    private final Integer minInc;
    @Nullable
    private final Integer maxInc;

    public RandomElement(@NonNull RollElement rollElement, @NonNull ImmutableList<String> randomSelectedFrom, @NonNull DieId dieId, int numberSupplierValue) {
        this(rollElement, randomSelectedFrom, null, null, dieId, numberSupplierValue);
        if (rollElement == null) {
            throw new NullPointerException("rollElement is marked non-null but is null");
        }
        if (randomSelectedFrom == null) {
            throw new NullPointerException("randomSelectedFrom is marked non-null but is null");
        }
        if (dieId == null) {
            throw new NullPointerException("dieId is marked non-null but is null");
        }
    }

    public RandomElement(@NonNull RollElement rollElement, int minInc, int maxInc, @NonNull DieId dieId, int numberSupplierValue) {
        this(rollElement, null, minInc, maxInc, dieId, numberSupplierValue);
        if (rollElement == null) {
            throw new NullPointerException("rollElement is marked non-null but is null");
        }
        if (dieId == null) {
            throw new NullPointerException("dieId is marked non-null but is null");
        }
    }

    private RandomElement(@NonNull RollElement rollElement, @Nullable ImmutableList<String> randomSelectedFrom, @Nullable Integer minInc, @Nullable Integer maxInc, @NonNull DieId dieId, int numberSupplierValue) {
        if (rollElement == null) {
            throw new NullPointerException("rollElement is marked non-null but is null");
        }
        if (dieId == null) {
            throw new NullPointerException("dieId is marked non-null but is null");
        }
        this.rollElement = rollElement;
        this.randomSelectedFrom = randomSelectedFrom;
        this.numberSupplierValue = numberSupplierValue;
        this.minInc = minInc;
        this.maxInc = maxInc;
        this.dieId = dieId;
    }

    public RandomElement copyWithTagAndColor(@NonNull String color) {
        if (color == null) {
            throw new NullPointerException("color is marked non-null but is null");
        }
        return new RandomElement(new RollElement(this.rollElement.getValue(), this.rollElement.getTag(), color), this.randomSelectedFrom, this.minInc, this.maxInc, this.dieId, this.numberSupplierValue);
    }

    public String toString() {
        if (this.randomSelectedFrom != null) {
            return "%s=%s\u2208%s".formatted(this.dieId, this.rollElement.toStringWithColorAndTag(), this.randomSelectedFrom);
        }
        return "%s=%s\u2208[%d...%d]".formatted(this.dieId, this.rollElement.toStringWithColorAndTag(), this.minInc, this.maxInc);
    }

    public DieIdAndValue getDiceIdAndValue() {
        return DieIdAndValue.of(this.dieId, this.numberSupplierValue);
    }

    @NonNull
    @Generated
    public RollElement getRollElement() {
        return this.rollElement;
    }

    @Nullable
    @Generated
    public ImmutableList<String> getRandomSelectedFrom() {
        return this.randomSelectedFrom;
    }

    @Generated
    public int getNumberSupplierValue() {
        return this.numberSupplierValue;
    }

    @NonNull
    @Generated
    public DieId getDieId() {
        return this.dieId;
    }

    @Nullable
    @Generated
    public Integer getMinInc() {
        return this.minInc;
    }

    @Nullable
    @Generated
    public Integer getMaxInc() {
        return this.maxInc;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RandomElement)) {
            return false;
        }
        RandomElement other = (RandomElement)o;
        if (this.getNumberSupplierValue() != other.getNumberSupplierValue()) {
            return false;
        }
        Integer this$minInc = this.getMinInc();
        Integer other$minInc = other.getMinInc();
        if (this$minInc == null ? other$minInc != null : !((Object)this$minInc).equals(other$minInc)) {
            return false;
        }
        Integer this$maxInc = this.getMaxInc();
        Integer other$maxInc = other.getMaxInc();
        if (this$maxInc == null ? other$maxInc != null : !((Object)this$maxInc).equals(other$maxInc)) {
            return false;
        }
        RollElement this$rollElement = this.getRollElement();
        RollElement other$rollElement = other.getRollElement();
        if (this$rollElement == null ? other$rollElement != null : !((Object)this$rollElement).equals(other$rollElement)) {
            return false;
        }
        ImmutableList<String> this$randomSelectedFrom = this.getRandomSelectedFrom();
        ImmutableList<String> other$randomSelectedFrom = other.getRandomSelectedFrom();
        if (this$randomSelectedFrom == null ? other$randomSelectedFrom != null : !this$randomSelectedFrom.equals(other$randomSelectedFrom)) {
            return false;
        }
        DieId this$dieId = this.getDieId();
        DieId other$dieId = other.getDieId();
        return !(this$dieId == null ? other$dieId != null : !((Object)this$dieId).equals(other$dieId));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getNumberSupplierValue();
        Integer $minInc = this.getMinInc();
        result = result * 59 + ($minInc == null ? 43 : ((Object)$minInc).hashCode());
        Integer $maxInc = this.getMaxInc();
        result = result * 59 + ($maxInc == null ? 43 : ((Object)$maxInc).hashCode());
        RollElement $rollElement = this.getRollElement();
        result = result * 59 + ($rollElement == null ? 43 : ((Object)$rollElement).hashCode());
        ImmutableList<String> $randomSelectedFrom = this.getRandomSelectedFrom();
        result = result * 59 + ($randomSelectedFrom == null ? 43 : $randomSelectedFrom.hashCode());
        DieId $dieId = this.getDieId();
        result = result * 59 + ($dieId == null ? 43 : ((Object)$dieId).hashCode());
        return result;
    }
}

