/*
 * Decompiled with CFR 0.152.
 */
package de.janno.evaluator.dice;

import com.google.common.collect.ImmutableList;
import de.janno.evaluator.dice.RandomElement;
import de.janno.evaluator.dice.Roll;
import de.janno.evaluator.dice.RollContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;

public class RandomElementsBuilder {
    private final List<RandomElement> randomElements = new ArrayList<RandomElement>();
    private final RollContext rollContext;

    private RandomElementsBuilder(@NonNull RollContext rollContext) {
        if (rollContext == null) {
            throw new NullPointerException("rollContext is marked non-null but is null");
        }
        this.rollContext = rollContext;
    }

    public static ImmutableList<RandomElement> fromRolls(@NonNull Collection<Roll> rolls, @NonNull RollContext rollContext) {
        if (rolls == null) {
            throw new NullPointerException("rolls is marked non-null but is null");
        }
        if (rollContext == null) {
            throw new NullPointerException("rollContext is marked non-null but is null");
        }
        return RandomElementsBuilder.ofRolls(rolls, rollContext).build();
    }

    public static RandomElementsBuilder empty(@NonNull RollContext rollContext) {
        if (rollContext == null) {
            throw new NullPointerException("rollContext is marked non-null but is null");
        }
        return new RandomElementsBuilder(rollContext);
    }

    public static RandomElementsBuilder ofRoll(@NonNull Roll roll, @NonNull RollContext rollContext) {
        if (roll == null) {
            throw new NullPointerException("roll is marked non-null but is null");
        }
        if (rollContext == null) {
            throw new NullPointerException("rollContext is marked non-null but is null");
        }
        return RandomElementsBuilder.ofRolls(List.of(roll), rollContext);
    }

    public static RandomElementsBuilder ofRolls(@NonNull Collection<Roll> rolls, @NonNull RollContext rollContext) {
        if (rolls == null) {
            throw new NullPointerException("rolls is marked non-null but is null");
        }
        if (rollContext == null) {
            throw new NullPointerException("rollContext is marked non-null but is null");
        }
        RandomElementsBuilder builder = new RandomElementsBuilder(rollContext);
        rolls.forEach(r -> builder.addRandomElements(r.getRandomElementsInRoll().stream().toList()));
        return builder;
    }

    public RandomElementsBuilder addRandomElements(@NonNull Collection<RandomElement> randomElements) {
        if (randomElements == null) {
            throw new NullPointerException("randomElements is marked non-null but is null");
        }
        this.randomElements.addAll(randomElements);
        return this;
    }

    public RandomElementsBuilder addRoll(@NonNull Roll roll) {
        if (roll == null) {
            throw new NullPointerException("roll is marked non-null but is null");
        }
        this.randomElements.addAll(roll.getRandomElementsInRoll().stream().toList());
        return this;
    }

    public RandomElementsBuilder addWithColor(@NonNull Roll roll, @NonNull String color) {
        if (roll == null) {
            throw new NullPointerException("roll is marked non-null but is null");
        }
        if (color == null) {
            throw new NullPointerException("color is marked non-null but is null");
        }
        this.randomElements.addAll(roll.getRandomElementsInRoll().stream().map(r -> r.copyWithTagAndColor(color)).toList());
        return this;
    }

    public ImmutableList<RandomElement> build() {
        HashMap uniqueMap = new HashMap(this.randomElements.size());
        this.randomElements.forEach(r -> uniqueMap.put(r.getDieId(), r));
        ImmutableList result = (ImmutableList)uniqueMap.values().stream().sorted(Comparator.comparing(RandomElement::getDieId)).collect(ImmutableList.toImmutableList());
        this.rollContext.addRandomElements((List<RandomElement>)result);
        return result;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RandomElementsBuilder)) {
            return false;
        }
        RandomElementsBuilder other = (RandomElementsBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<RandomElement> this$randomElements = this.getRandomElements();
        List<RandomElement> other$randomElements = other.getRandomElements();
        if (this$randomElements == null ? other$randomElements != null : !((Object)this$randomElements).equals(other$randomElements)) {
            return false;
        }
        RollContext this$rollContext = this.getRollContext();
        RollContext other$rollContext = other.getRollContext();
        return !(this$rollContext == null ? other$rollContext != null : !this$rollContext.equals(other$rollContext));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RandomElementsBuilder;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<RandomElement> $randomElements = this.getRandomElements();
        result = result * 59 + ($randomElements == null ? 43 : ((Object)$randomElements).hashCode());
        RollContext $rollContext = this.getRollContext();
        result = result * 59 + ($rollContext == null ? 43 : $rollContext.hashCode());
        return result;
    }

    @Generated
    public List<RandomElement> getRandomElements() {
        return this.randomElements;
    }

    @Generated
    public RollContext getRollContext() {
        return this.rollContext;
    }
}

