/*
 * Decompiled with CFR 0.152.
 */
package de.janno.evaluator.dice;

import com.google.common.collect.ImmutableList;
import de.janno.evaluator.dice.DieId;
import de.janno.evaluator.dice.ExpressionException;
import de.janno.evaluator.dice.ExpressionPosition;
import de.janno.evaluator.dice.RandomElement;
import de.janno.evaluator.dice.RollElement;
import de.janno.evaluator.dice.RollId;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;

public class Roll {
    @NonNull
    private final String expression;
    @NonNull
    private final ImmutableList<RollElement> elements;
    @NonNull
    private final ImmutableList<RandomElement> randomElementsInRoll;
    @NonNull
    private final ImmutableList<Roll> childrenRolls;
    @NonNull
    private final ExpressionPosition expressionPosition;

    public Roll(@NonNull String expression, @NonNull ImmutableList<RollElement> elements, @NonNull ImmutableList<RandomElement> randomElementsInRoll, @NonNull ImmutableList<Roll> childrenRolls, @NonNull ExpressionPosition expressionPosition, int maxNumberOfElements, boolean keepChildRolls) throws ExpressionException {
        if (expression == null) {
            throw new NullPointerException("expression is marked non-null but is null");
        }
        if (elements == null) {
            throw new NullPointerException("elements is marked non-null but is null");
        }
        if (randomElementsInRoll == null) {
            throw new NullPointerException("randomElementsInRoll is marked non-null but is null");
        }
        if (childrenRolls == null) {
            throw new NullPointerException("childrenRolls is marked non-null but is null");
        }
        if (expressionPosition == null) {
            throw new NullPointerException("expressionPosition is marked non-null but is null");
        }
        this.expression = expression;
        this.elements = elements;
        this.validate(randomElementsInRoll);
        this.randomElementsInRoll = randomElementsInRoll;
        this.childrenRolls = keepChildRolls ? childrenRolls : ImmutableList.of();
        this.expressionPosition = expressionPosition;
        if (elements.size() > maxNumberOfElements) {
            throw new ExpressionException("To many elements in roll '%s', max is %d but there where %d".formatted(expression, maxNumberOfElements, elements.size()), expressionPosition);
        }
        long numberOfRandomElementsInRoll = randomElementsInRoll.size();
        if (numberOfRandomElementsInRoll > (long)maxNumberOfElements) {
            throw new ExpressionException("To many random elements in roll '%s', max is %d but there where %d".formatted(expression, maxNumberOfElements, numberOfRandomElementsInRoll), expressionPosition);
        }
    }

    private void validate(ImmutableList<RandomElement> randomElements) {
        List<DieId> diceIdsWithDuplicatedRandomElements = randomElements.stream().collect(Collectors.groupingBy(RandomElement::getDieId)).values().stream().filter(l -> l.size() > 1).map(r -> ((RandomElement)r.getFirst()).getDieId()).toList();
        if (!diceIdsWithDuplicatedRandomElements.isEmpty()) {
            throw new IllegalStateException("Random elements must have unique dice ids but %s occurred more than once".formatted(diceIdsWithDuplicatedRandomElements));
        }
    }

    public Optional<String> asSingleValue() {
        if (this.elements.size() == 1) {
            return Optional.of(((RollElement)this.elements.getFirst()).getValue());
        }
        return Optional.empty();
    }

    public Optional<Integer> asInteger() {
        if (this.elements.size() == 1) {
            return ((RollElement)this.elements.getFirst()).asInteger();
        }
        return Optional.empty();
    }

    public Optional<BigDecimal> asDecimal() {
        if (this.elements.size() == 1) {
            return ((RollElement)this.elements.getFirst()).asDecimal();
        }
        return Optional.empty();
    }

    public Optional<Boolean> asBoolean() {
        if (this.elements.size() == 1) {
            return ((RollElement)this.elements.getFirst()).asBoolean();
        }
        return Optional.empty();
    }

    public boolean containsOnlyDecimals() {
        return this.elements.stream().map(RollElement::asDecimal).allMatch(Optional::isPresent);
    }

    public String getResultString() {
        return this.elements.stream().map(RollElement::toString).collect(Collectors.joining(", "));
    }

    public String getResultStringWithTagAndColor() {
        return this.elements.stream().map(RollElement::toStringWithColorAndTag).collect(Collectors.joining(", "));
    }

    public String toString() {
        return "Roll{expression='" + this.expression + "', randomElementsInRoll=" + String.valueOf(this.randomElementsInRoll) + ", elements=" + String.valueOf(this.elements) + "}";
    }

    public boolean equalForValueAndTag(Roll other) {
        if (this.getElements().size() != other.getElements().size()) {
            return false;
        }
        for (int i = 0; i < this.getElements().size(); ++i) {
            if (((RollElement)this.getElements().get(i)).isEqualValueAndTag((RollElement)other.getElements().get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean isElementsContainsElementWithValueAndTag(RollElement rollElement) {
        return this.elements.stream().anyMatch(e -> e.isEqualValueAndTag(rollElement));
    }

    public ImmutableList<ImmutableList<RandomElement>> getGroupedRandomElements() {
        List<RollId> rollIds = this.randomElementsInRoll.stream().map(RandomElement::getDieId).map(DieId::getRollId).distinct().sorted().toList();
        Map<RollId, List<RandomElement>> rollIdListMap = this.randomElementsInRoll.stream().collect(Collectors.groupingBy(r -> r.getDieId().getRollId()));
        return (ImmutableList)rollIds.stream().map(rid -> (ImmutableList)((List)rollIdListMap.get(rid)).stream().sorted(Comparator.comparing(RandomElement::getDieId)).collect(ImmutableList.toImmutableList())).collect(ImmutableList.toImmutableList());
    }

    @NonNull
    @Generated
    public String getExpression() {
        return this.expression;
    }

    @NonNull
    @Generated
    public ImmutableList<RollElement> getElements() {
        return this.elements;
    }

    @NonNull
    @Generated
    public ImmutableList<RandomElement> getRandomElementsInRoll() {
        return this.randomElementsInRoll;
    }

    @NonNull
    @Generated
    public ImmutableList<Roll> getChildrenRolls() {
        return this.childrenRolls;
    }

    @NonNull
    @Generated
    public ExpressionPosition getExpressionPosition() {
        return this.expressionPosition;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Roll)) {
            return false;
        }
        Roll other = (Roll)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$expression = this.getExpression();
        String other$expression = other.getExpression();
        if (this$expression == null ? other$expression != null : !this$expression.equals(other$expression)) {
            return false;
        }
        ImmutableList<RollElement> this$elements = this.getElements();
        ImmutableList<RollElement> other$elements = other.getElements();
        if (this$elements == null ? other$elements != null : !this$elements.equals(other$elements)) {
            return false;
        }
        ImmutableList<RandomElement> this$randomElementsInRoll = this.getRandomElementsInRoll();
        ImmutableList<RandomElement> other$randomElementsInRoll = other.getRandomElementsInRoll();
        if (this$randomElementsInRoll == null ? other$randomElementsInRoll != null : !this$randomElementsInRoll.equals(other$randomElementsInRoll)) {
            return false;
        }
        ImmutableList<Roll> this$childrenRolls = this.getChildrenRolls();
        ImmutableList<Roll> other$childrenRolls = other.getChildrenRolls();
        if (this$childrenRolls == null ? other$childrenRolls != null : !this$childrenRolls.equals(other$childrenRolls)) {
            return false;
        }
        ExpressionPosition this$expressionPosition = this.getExpressionPosition();
        ExpressionPosition other$expressionPosition = other.getExpressionPosition();
        return !(this$expressionPosition == null ? other$expressionPosition != null : !((Object)this$expressionPosition).equals(other$expressionPosition));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Roll;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $expression = this.getExpression();
        result = result * 59 + ($expression == null ? 43 : $expression.hashCode());
        ImmutableList<RollElement> $elements = this.getElements();
        result = result * 59 + ($elements == null ? 43 : $elements.hashCode());
        ImmutableList<RandomElement> $randomElementsInRoll = this.getRandomElementsInRoll();
        result = result * 59 + ($randomElementsInRoll == null ? 43 : $randomElementsInRoll.hashCode());
        ImmutableList<Roll> $childrenRolls = this.getChildrenRolls();
        result = result * 59 + ($childrenRolls == null ? 43 : $childrenRolls.hashCode());
        ExpressionPosition $expressionPosition = this.getExpressionPosition();
        result = result * 59 + ($expressionPosition == null ? 43 : ((Object)$expressionPosition).hashCode());
        return result;
    }
}

