/*
 * Decompiled with CFR 0.152.
 */
package de.janno.evaluator.dice;

import com.google.common.collect.ImmutableList;
import de.janno.evaluator.dice.ExpressionException;
import de.janno.evaluator.dice.Roll;
import de.janno.evaluator.dice.RollContext;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;

public interface RollBuilder {
    public static ImmutableList<Roll> extendAllBuilder(@NonNull List<RollBuilder> rollBuilders, @NonNull RollContext rollContext) throws ExpressionException {
        if (rollBuilders == null) {
            throw new NullPointerException("rollBuilders is marked non-null but is null");
        }
        if (rollContext == null) {
            throw new NullPointerException("rollContext is marked non-null but is null");
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (RollBuilder rs : rollBuilders) {
            RollBuilder.extendRollBuilder(rollContext, rs, (ImmutableList.Builder<Roll>)builder);
        }
        return builder.build();
    }

    public static void extendRollBuilder(@NonNull RollContext rollContext, @NonNull RollBuilder rs, @NonNull ImmutableList.Builder<Roll> builder) throws ExpressionException {
        if (rollContext == null) {
            throw new NullPointerException("rollContext is marked non-null but is null");
        }
        if (rs == null) {
            throw new NullPointerException("rs is marked non-null but is null");
        }
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        Optional<List<Roll>> r = rs.extendRoll(rollContext);
        r.ifPresent(arg_0 -> builder.addAll(arg_0));
    }

    @NonNull
    public Optional<List<Roll>> extendRoll(@NonNull RollContext var1) throws ExpressionException;

    @NonNull
    public String toExpression();
}

