/*
 * Decompiled with CFR 0.152.
 */
package de.janno.evaluator.dice;

import com.google.common.collect.ImmutableList;
import de.janno.evaluator.dice.DieId;
import de.janno.evaluator.dice.ExpressionPosition;
import de.janno.evaluator.dice.RandomElement;
import de.janno.evaluator.dice.Roll;
import de.janno.evaluator.dice.random.NumberSupplier;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;

public class RollContext {
    private final List<String> expressionPrefix = new ArrayList<String>();
    private final Map<String, Roll> currentVariables;
    private final Map<ExpressionPosition, AtomicInteger> reEvaluationNumber;
    private final NumberSupplier numberSupplier;
    private final Map<DieId, RandomElement> randomElements;

    public RollContext(NumberSupplier numberSupplier) {
        this(new ConcurrentHashMap<String, Roll>(), new ConcurrentHashMap<ExpressionPosition, AtomicInteger>(), numberSupplier, new ConcurrentHashMap<DieId, RandomElement>());
    }

    private RollContext(Map<String, Roll> variables, Map<ExpressionPosition, AtomicInteger> reEvaluationNumber, NumberSupplier numberSupplier, Map<DieId, RandomElement> randomElements) {
        this.currentVariables = variables;
        this.reEvaluationNumber = reEvaluationNumber;
        this.numberSupplier = numberSupplier;
        this.randomElements = randomElements;
    }

    public int getNextReEvaluationNumber(ExpressionPosition expressionPosition) {
        return this.reEvaluationNumber.computeIfAbsent(expressionPosition, s -> new AtomicInteger(0)).getAndIncrement();
    }

    public RollContext copy() {
        return new RollContext(new ConcurrentHashMap<String, Roll>(this.currentVariables), new ConcurrentHashMap<ExpressionPosition, AtomicInteger>(this.reEvaluationNumber), this.numberSupplier, new ConcurrentHashMap<DieId, RandomElement>(this.randomElements));
    }

    public RollContext copyWithEmptyVariables() {
        return new RollContext(new ConcurrentHashMap<String, Roll>(), new ConcurrentHashMap<ExpressionPosition, AtomicInteger>(this.reEvaluationNumber), this.numberSupplier, new ConcurrentHashMap<DieId, RandomElement>(this.randomElements));
    }

    public void merge(RollContext rollContext) {
        this.currentVariables.putAll(rollContext.currentVariables);
        this.reEvaluationNumber.putAll(rollContext.reEvaluationNumber);
        this.expressionPrefix.addAll(rollContext.expressionPrefix);
    }

    public void putVariable(String name, Roll roll) {
        this.expressionPrefix.add(roll.getExpression());
        this.currentVariables.put(name, roll);
    }

    public Optional<Roll> getVariable(String name) {
        return Optional.ofNullable(this.currentVariables.get(name));
    }

    public Optional<String> getExpressionPrefixString() {
        if (this.expressionPrefix.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(String.join((CharSequence)", ", this.expressionPrefix));
    }

    public void addRandomElements(List<RandomElement> uniqueList) {
        uniqueList.forEach(r -> this.randomElements.put(r.getDieId(), (RandomElement)r));
    }

    public ImmutableList<RandomElement> getAllRandomElements() {
        return (ImmutableList)this.randomElements.values().stream().sorted(Comparator.comparing(RandomElement::getDieId)).collect(ImmutableList.toImmutableList());
    }

    @Generated
    public NumberSupplier getNumberSupplier() {
        return this.numberSupplier;
    }
}

