/*
 * Decompiled with CFR 0.152.
 */
package de.janno.evaluator.dice;

import com.google.common.base.Strings;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;

public final class RollElement
implements Comparable<RollElement> {
    public static final String NO_TAG = "";
    public static final String NO_COLOR = "";
    @NonNull
    private final String value;
    @NonNull
    private final String tag;
    @NonNull
    private final String color;

    public Optional<Integer> asInteger() {
        try {
            return Optional.of(Integer.parseInt(this.value));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    public Optional<BigDecimal> asDecimal() {
        try {
            return Optional.of(new BigDecimal(this.value));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    public Optional<Boolean> asBoolean() {
        if (this.value.equals(String.valueOf(true)) || this.value.equals("1")) {
            return Optional.of(true);
        }
        if (this.value.equals(String.valueOf(false)) || this.value.equals("0")) {
            return Optional.of(false);
        }
        return Optional.empty();
    }

    @Override
    public int compareTo(@NonNull RollElement rollElement) {
        if (rollElement == null) {
            throw new NullPointerException("rollElement is marked non-null but is null");
        }
        if (!this.getTag().equals(rollElement.getTag())) {
            return this.getTag().compareTo(rollElement.getTag());
        }
        if (this.asInteger().isPresent() && rollElement.asInteger().isPresent()) {
            return this.asInteger().get().compareTo(rollElement.asInteger().get());
        }
        return this.getValue().compareTo(rollElement.getValue());
    }

    public boolean isEqualValueAndTag(@NonNull RollElement rollElement) {
        if (rollElement == null) {
            throw new NullPointerException("rollElement is marked non-null but is null");
        }
        return Objects.equals(this.getTag(), rollElement.getTag()) && Objects.equals(rollElement.getValue(), this.getValue());
    }

    public String toString() {
        String outputTag = "".equals(this.tag) ? "" : "%s:".formatted(this.tag);
        return "%s%s".formatted(outputTag, this.value);
    }

    public String toStringWithColorAndTag() {
        String outputTag = "".equals(this.tag) ? "" : "t:%s".formatted(this.tag);
        String outputColor = "".equals(this.color) ? "" : "c:%s".formatted(this.color);
        return Stream.of(this.value, outputTag, outputColor).filter(s -> !Strings.isNullOrEmpty((String)s)).collect(Collectors.joining("-"));
    }

    @NonNull
    @Generated
    public String getValue() {
        return this.value;
    }

    @NonNull
    @Generated
    public String getTag() {
        return this.tag;
    }

    @NonNull
    @Generated
    public String getColor() {
        return this.color;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RollElement)) {
            return false;
        }
        RollElement other = (RollElement)o;
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$tag = this.getTag();
        String other$tag = other.getTag();
        if (this$tag == null ? other$tag != null : !this$tag.equals(other$tag)) {
            return false;
        }
        String this$color = this.getColor();
        String other$color = other.getColor();
        return !(this$color == null ? other$color != null : !this$color.equals(other$color));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $tag = this.getTag();
        result = result * 59 + ($tag == null ? 43 : $tag.hashCode());
        String $color = this.getColor();
        result = result * 59 + ($color == null ? 43 : $color.hashCode());
        return result;
    }

    @Generated
    public RollElement(@NonNull String value, @NonNull String tag, @NonNull String color) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        if (color == null) {
            throw new NullPointerException("color is marked non-null but is null");
        }
        this.value = value;
        this.tag = tag;
        this.color = color;
    }
}

