/*
 * Decompiled with CFR 0.152.
 */
package de.janno.evaluator.dice;

import com.google.common.collect.ImmutableList;
import de.janno.evaluator.dice.DieId;
import de.janno.evaluator.dice.RandomElement;
import de.janno.evaluator.dice.Roll;
import de.janno.evaluator.dice.RollId;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;

public final class RollResult {
    @NonNull
    private final String expression;
    @NonNull
    private final ImmutableList<Roll> rolls;
    @NonNull
    private final ImmutableList<RandomElement> allRandomElements;

    public ImmutableList<ImmutableList<RandomElement>> getGroupedRandomElements() {
        List<RollId> rollIds = this.allRandomElements.stream().map(RandomElement::getDieId).map(DieId::getRollId).distinct().sorted().toList();
        Map<RollId, List<RandomElement>> rollIdListMap = this.allRandomElements.stream().collect(Collectors.groupingBy(r -> r.getDieId().getRollId()));
        return (ImmutableList)rollIds.stream().map(rid -> (ImmutableList)((List)rollIdListMap.get(rid)).stream().sorted(Comparator.comparing(RandomElement::getDieId)).collect(ImmutableList.toImmutableList())).collect(ImmutableList.toImmutableList());
    }

    @Generated
    public RollResult(@NonNull String expression, @NonNull ImmutableList<Roll> rolls, @NonNull ImmutableList<RandomElement> allRandomElements) {
        if (expression == null) {
            throw new NullPointerException("expression is marked non-null but is null");
        }
        if (rolls == null) {
            throw new NullPointerException("rolls is marked non-null but is null");
        }
        if (allRandomElements == null) {
            throw new NullPointerException("allRandomElements is marked non-null but is null");
        }
        this.expression = expression;
        this.rolls = rolls;
        this.allRandomElements = allRandomElements;
    }

    @NonNull
    @Generated
    public String getExpression() {
        return this.expression;
    }

    @NonNull
    @Generated
    public ImmutableList<Roll> getRolls() {
        return this.rolls;
    }

    @NonNull
    @Generated
    public ImmutableList<RandomElement> getAllRandomElements() {
        return this.allRandomElements;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RollResult)) {
            return false;
        }
        RollResult other = (RollResult)o;
        String this$expression = this.getExpression();
        String other$expression = other.getExpression();
        if (this$expression == null ? other$expression != null : !this$expression.equals(other$expression)) {
            return false;
        }
        ImmutableList<Roll> this$rolls = this.getRolls();
        ImmutableList<Roll> other$rolls = other.getRolls();
        if (this$rolls == null ? other$rolls != null : !this$rolls.equals(other$rolls)) {
            return false;
        }
        ImmutableList<RandomElement> this$allRandomElements = this.getAllRandomElements();
        ImmutableList<RandomElement> other$allRandomElements = other.getAllRandomElements();
        return !(this$allRandomElements == null ? other$allRandomElements != null : !this$allRandomElements.equals(other$allRandomElements));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $expression = this.getExpression();
        result = result * 59 + ($expression == null ? 43 : $expression.hashCode());
        ImmutableList<Roll> $rolls = this.getRolls();
        result = result * 59 + ($rolls == null ? 43 : $rolls.hashCode());
        ImmutableList<RandomElement> $allRandomElements = this.getAllRandomElements();
        result = result * 59 + ($allRandomElements == null ? 43 : $allRandomElements.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RollResult(expression=" + this.getExpression() + ", rolls=" + String.valueOf(this.getRolls()) + ", allRandomElements=" + String.valueOf(this.getAllRandomElements()) + ")";
    }
}

