/*
 * Decompiled with CFR 0.152.
 */
package de.janno.evaluator.dice;

import de.janno.evaluator.dice.BracketPair;
import de.janno.evaluator.dice.ExpressionPosition;
import de.janno.evaluator.dice.Function;
import de.janno.evaluator.dice.Operator;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;

public class Token {
    @NonNull
    private final ExpressionPosition expressionPosition;
    @NonNull
    private final Kind kind;
    private final Operator operator;
    private final Function function;
    private final String literal;
    private final BracketPair bracketPair;
    private final Operator.OperatorType operatorType;

    private Token(@NonNull Kind kind, @NonNull ExpressionPosition expressionPosition, Operator operator, Function function, String literal, Operator.OperatorType operatorType, BracketPair bracketPair) {
        if (kind == null) {
            throw new NullPointerException("kind is marked non-null but is null");
        }
        if (expressionPosition == null) {
            throw new NullPointerException("expressionPosition is marked non-null but is null");
        }
        this.kind = kind;
        this.expressionPosition = expressionPosition;
        this.operator = operator;
        this.function = function;
        this.literal = literal;
        this.operatorType = operatorType;
        this.bracketPair = bracketPair;
    }

    public static Token addOpenBracket(@NonNull Token token, @NonNull String brackets) {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        if (brackets == null) {
            throw new NullPointerException("brackets is marked non-null but is null");
        }
        return new Token(token.kind, token.expressionPosition.extendLeft(brackets), token.operator, token.function, token.literal, token.operatorType, token.bracketPair);
    }

    public static Token addCloseBracket(@NonNull Token token, @NonNull String brackets) {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        if (brackets == null) {
            throw new NullPointerException("brackets is marked non-null but is null");
        }
        return new Token(token.kind, token.expressionPosition.extendRight(brackets), token.operator, token.function, token.literal, token.operatorType, token.bracketPair);
    }

    public static Token of(@NonNull Operator operator, @NonNull ExpressionPosition expressionPosition) {
        if (operator == null) {
            throw new NullPointerException("operator is marked non-null but is null");
        }
        if (expressionPosition == null) {
            throw new NullPointerException("expressionPosition is marked non-null but is null");
        }
        return new Token(Kind.OPERATOR, expressionPosition, operator, null, null, null, null);
    }

    public static Token of(@NonNull Operator operator, @NonNull Operator.OperatorType operatorType, @NonNull ExpressionPosition expressionPosition) {
        if (operator == null) {
            throw new NullPointerException("operator is marked non-null but is null");
        }
        if (operatorType == null) {
            throw new NullPointerException("operatorType is marked non-null but is null");
        }
        if (expressionPosition == null) {
            throw new NullPointerException("expressionPosition is marked non-null but is null");
        }
        if (operatorType == Operator.OperatorType.UNARY && !operator.supportUnaryOperation()) {
            throw new IllegalArgumentException(String.valueOf(operator) + "only supports binary operation");
        }
        if (operatorType == Operator.OperatorType.BINARY && !operator.supportBinaryOperation()) {
            throw new IllegalArgumentException(String.valueOf(operator) + "only supports unary operation");
        }
        return new Token(Kind.OPERATOR, expressionPosition, operator, null, null, operatorType, null);
    }

    public static Token of(@NonNull Function function, @NonNull ExpressionPosition expressionPosition) {
        if (function == null) {
            throw new NullPointerException("function is marked non-null but is null");
        }
        if (expressionPosition == null) {
            throw new NullPointerException("expressionPosition is marked non-null but is null");
        }
        return new Token(Kind.FUNCTION, expressionPosition, null, function, null, null, null);
    }

    public static Token of(@NonNull String literal, @NonNull ExpressionPosition expressionPosition) {
        if (literal == null) {
            throw new NullPointerException("literal is marked non-null but is null");
        }
        if (expressionPosition == null) {
            throw new NullPointerException("expressionPosition is marked non-null but is null");
        }
        return new Token(Kind.LITERAL, expressionPosition, null, null, literal, null, null);
    }

    public static Token openTokenOf(@NonNull BracketPair bracketPair, @NonNull ExpressionPosition expressionPosition) {
        if (bracketPair == null) {
            throw new NullPointerException("bracketPair is marked non-null but is null");
        }
        if (expressionPosition == null) {
            throw new NullPointerException("expressionPosition is marked non-null but is null");
        }
        return new Token(Kind.OPEN_BRACKET, expressionPosition, null, null, null, null, bracketPair);
    }

    public static Token closeTokenOf(@NonNull BracketPair bracketPair, @NonNull ExpressionPosition expressionPosition) {
        if (bracketPair == null) {
            throw new NullPointerException("bracketPair is marked non-null but is null");
        }
        if (expressionPosition == null) {
            throw new NullPointerException("expressionPosition is marked non-null but is null");
        }
        return new Token(Kind.CLOSE_BRACKET, expressionPosition, null, null, null, null, bracketPair);
    }

    public static Token separator(@NonNull ExpressionPosition expressionPosition) {
        if (expressionPosition == null) {
            throw new NullPointerException("expressionPosition is marked non-null but is null");
        }
        return new Token(Kind.SEPARATOR, expressionPosition, null, null, null, null, null);
    }

    public Optional<BracketPair> getBrackets() {
        return Optional.ofNullable(this.bracketPair);
    }

    public Optional<Operator> getOperator() {
        return Optional.ofNullable(this.operator);
    }

    public Optional<Operator.OperatorType> getOperatorType() {
        return Optional.ofNullable(this.operatorType);
    }

    public Optional<Function> getFunction() {
        return Optional.ofNullable(this.function);
    }

    public Optional<String> getLiteral() {
        return Optional.ofNullable(this.literal);
    }

    public boolean isOpenBracket() {
        return this.kind.equals((Object)Kind.OPEN_BRACKET);
    }

    public boolean isCloseBracket() {
        return this.kind.equals((Object)Kind.CLOSE_BRACKET);
    }

    public boolean isSeparator() {
        return this.kind.equals((Object)Kind.SEPARATOR);
    }

    public Optional<Operator.Associativity> getOperatorAssociativity() {
        return this.getOperator().map(o -> o.getAssociativityForOperantType(this.operatorType));
    }

    public Optional<Integer> getOperatorPrecedence() {
        return this.getOperator().map(o -> o.getPrecedenceForOperantType(this.operatorType));
    }

    public String toString() {
        return switch (this.kind.ordinal()) {
            default -> throw new MatchException(null, null);
            case 4 -> this.operator.getName();
            case 3 -> this.function.getName();
            case 5 -> "'%s'".formatted(this.literal);
            case 0 -> this.bracketPair.getOpen();
            case 1 -> this.bracketPair.getClose();
            case 2 -> "SEPARATOR";
        };
    }

    @NonNull
    @Generated
    public ExpressionPosition getExpressionPosition() {
        return this.expressionPosition;
    }

    private static enum Kind {
        OPEN_BRACKET,
        CLOSE_BRACKET,
        SEPARATOR,
        FUNCTION,
        OPERATOR,
        LITERAL;

    }
}

