/*
 * Decompiled with CFR 0.152.
 */
package de.janno.evaluator.dice.function;

import com.google.common.collect.ImmutableList;
import de.janno.evaluator.dice.ExpressionException;
import de.janno.evaluator.dice.ExpressionPosition;
import de.janno.evaluator.dice.Function;
import de.janno.evaluator.dice.RandomElementsBuilder;
import de.janno.evaluator.dice.Roll;
import de.janno.evaluator.dice.RollBuilder;
import de.janno.evaluator.dice.RollContext;
import de.janno.evaluator.dice.ValidatorUtil;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;

public abstract class AbstractIf
extends Function {
    public AbstractIf(@NonNull String name, int maxNumberOfElements, boolean keepChildrenRolls) {
        super(name, 3, Integer.MAX_VALUE, maxNumberOfElements, keepChildrenRolls);
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
    }

    @Override
    @NonNull
    public RollBuilder evaluate(final @NonNull List<RollBuilder> arguments, final @NonNull ExpressionPosition expressionPosition) throws ExpressionException {
        if (arguments == null) {
            throw new NullPointerException("arguments is marked non-null but is null");
        }
        if (expressionPosition == null) {
            throw new NullPointerException("expressionPosition is marked non-null but is null");
        }
        return new RollBuilder(){

            @Override
            @NonNull
            public Optional<List<Roll>> extendRoll(@NonNull RollContext rollContext) throws ExpressionException {
                Roll result;
                int counter;
                if (rollContext == null) {
                    throw new NullPointerException("rollContext is marked non-null but is null");
                }
                ImmutableList<Roll> rolls = RollBuilder.extendAllBuilder(arguments, rollContext);
                ValidatorUtil.checkRollSize(expressionPosition, rolls, AbstractIf.this.getMinArgumentCount(), AbstractIf.this.getMaxArgumentCount());
                Roll input = (Roll)rolls.getFirst();
                RandomElementsBuilder randomElementsBuilder = RandomElementsBuilder.ofRoll(input, rollContext);
                for (counter = 1; counter < rolls.size() - 1; counter += 2) {
                    Roll compareTo = (Roll)rolls.get(counter);
                    Roll trueResult = (Roll)rolls.get(counter + 1);
                    randomElementsBuilder.addRoll(compareTo);
                    if (!AbstractIf.this.compare(input, counter, compareTo, counter + 1, expressionPosition)) continue;
                    randomElementsBuilder.addRoll(trueResult);
                    return Optional.of(ImmutableList.of((Object)new Roll(this.toExpression(), trueResult.getElements(), randomElementsBuilder.build(), (ImmutableList<Roll>)ImmutableList.builder().addAll(input.getChildrenRolls()).addAll(trueResult.getChildrenRolls()).build(), expressionPosition, AbstractIf.this.maxNumberOfElements, AbstractIf.this.keepChildrenRolls)));
                }
                if (counter != rolls.size()) {
                    result = (Roll)rolls.getLast();
                    randomElementsBuilder.addRoll(result);
                } else {
                    result = input;
                }
                return Optional.of(ImmutableList.of((Object)new Roll(this.toExpression(), result.getElements(), randomElementsBuilder.build(), (ImmutableList<Roll>)ImmutableList.builder().addAll(input.getChildrenRolls()).addAll(result.getChildrenRolls()).build(), expressionPosition, AbstractIf.this.maxNumberOfElements, AbstractIf.this.keepChildrenRolls)));
            }

            @Override
            @NonNull
            public String toExpression() {
                return AbstractIf.getExpression(expressionPosition, arguments);
            }
        };
    }

    protected abstract boolean compare(Roll var1, int var2, Roll var3, int var4, ExpressionPosition var5) throws ExpressionException;
}

