/*
 * Decompiled with CFR 0.152.
 */
package de.janno.evaluator.dice.function;

import com.google.common.collect.ImmutableList;
import de.janno.evaluator.dice.ExpressionException;
import de.janno.evaluator.dice.ExpressionPosition;
import de.janno.evaluator.dice.Function;
import de.janno.evaluator.dice.RandomElementsBuilder;
import de.janno.evaluator.dice.Roll;
import de.janno.evaluator.dice.RollBuilder;
import de.janno.evaluator.dice.RollContext;
import de.janno.evaluator.dice.RollElement;
import de.janno.evaluator.dice.ValidatorUtil;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;

public class Cancel
extends Function {
    public Cancel(int maxNumberOfElements, boolean keepChildrenRolls) {
        super("cancel", 3, maxNumberOfElements, keepChildrenRolls);
    }

    @Override
    @NonNull
    public RollBuilder evaluate(final @NonNull List<RollBuilder> arguments, final @NonNull ExpressionPosition expressionPosition) throws ExpressionException {
        if (arguments == null) {
            throw new NullPointerException("arguments is marked non-null but is null");
        }
        if (expressionPosition == null) {
            throw new NullPointerException("expressionPosition is marked non-null but is null");
        }
        return new RollBuilder(){

            @Override
            @NonNull
            public Optional<List<Roll>> extendRoll(@NonNull RollContext rollContext) throws ExpressionException {
                if (rollContext == null) {
                    throw new NullPointerException("rollContext is marked non-null but is null");
                }
                ImmutableList<Roll> rolls = RollBuilder.extendAllBuilder(arguments, rollContext);
                ValidatorUtil.checkRollSize(expressionPosition, rolls, Cancel.this.getMinArgumentCount(), Cancel.this.getMaxArgumentCount());
                Roll input = (Roll)rolls.getFirst();
                Roll typeA = (Roll)rolls.get(1);
                Roll typeB = (Roll)rolls.get(2);
                List noMatch = (List)input.getElements().stream().filter(r -> !typeA.isElementsContainsElementWithValueAndTag((RollElement)r) && !typeB.isElementsContainsElementWithValueAndTag((RollElement)r)).collect(ImmutableList.toImmutableList());
                List typeAMatch = (List)input.getElements().stream().filter(typeA::isElementsContainsElementWithValueAndTag).collect(ImmutableList.toImmutableList());
                List typeBMatch = (List)input.getElements().stream().filter(typeB::isElementsContainsElementWithValueAndTag).collect(ImmutableList.toImmutableList());
                ImmutableList.Builder resultBuilder = ImmutableList.builder().addAll((Iterable)noMatch);
                if (typeAMatch.size() > typeBMatch.size()) {
                    resultBuilder.addAll(Cancel.this.getChancel(typeAMatch, typeBMatch));
                } else if (typeAMatch.size() < typeBMatch.size()) {
                    resultBuilder.addAll(Cancel.this.getChancel(typeBMatch, typeAMatch));
                }
                return Optional.of(ImmutableList.of((Object)new Roll(this.toExpression(), (ImmutableList<RollElement>)resultBuilder.build(), RandomElementsBuilder.fromRolls(rolls, rollContext), (ImmutableList<Roll>)ImmutableList.builder().addAll(input.getChildrenRolls()).addAll(typeA.getChildrenRolls()).addAll(typeB.getChildrenRolls()).build(), expressionPosition, Cancel.this.maxNumberOfElements, Cancel.this.keepChildrenRolls)));
            }

            @Override
            @NonNull
            public String toExpression() {
                return Cancel.getExpression(expressionPosition, arguments);
            }
        };
    }

    private List<RollElement> getChancel(List<RollElement> bigger, List<RollElement> smaller) {
        return bigger.subList(smaller.size(), bigger.size());
    }
}

