/*
 * Decompiled with CFR 0.152.
 */
package de.janno.evaluator.dice.function;

import com.google.common.collect.ImmutableList;
import de.janno.evaluator.dice.ExpressionException;
import de.janno.evaluator.dice.ExpressionPosition;
import de.janno.evaluator.dice.Function;
import de.janno.evaluator.dice.RandomElement;
import de.janno.evaluator.dice.RandomElementsBuilder;
import de.janno.evaluator.dice.Roll;
import de.janno.evaluator.dice.RollBuilder;
import de.janno.evaluator.dice.RollContext;
import de.janno.evaluator.dice.RollElement;
import de.janno.evaluator.dice.ValidatorUtil;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;

public class ColorOn
extends Function {
    public ColorOn(int maxNumberOfElements, boolean keepChildrenRolls) {
        super("colorOn", 3, Integer.MAX_VALUE, maxNumberOfElements, keepChildrenRolls);
    }

    @Override
    @NonNull
    public RollBuilder evaluate(final @NonNull List<RollBuilder> arguments, final @NonNull ExpressionPosition expressionPosition) throws ExpressionException {
        if (arguments == null) {
            throw new NullPointerException("arguments is marked non-null but is null");
        }
        if (expressionPosition == null) {
            throw new NullPointerException("expressionPosition is marked non-null but is null");
        }
        return new RollBuilder(){

            @Override
            @NonNull
            public Optional<List<Roll>> extendRoll(@NonNull RollContext rollContext) throws ExpressionException {
                if (rollContext == null) {
                    throw new NullPointerException("rollContext is marked non-null but is null");
                }
                if (arguments.size() % 2 == 0) {
                    throw new ExpressionException(String.format("'%s' requires an odd number of arguments but was %d", ColorOn.this.getName(), arguments.size()), expressionPosition);
                }
                Optional<List<Roll>> input = ((RollBuilder)arguments.getFirst()).extendRoll(rollContext);
                if (input.isEmpty()) {
                    return Optional.of(List.of());
                }
                ImmutableList.Builder allRolls = ImmutableList.builder().addAll((Iterable)input.get());
                ImmutableList inputRollElements = (ImmutableList)input.get().stream().flatMap(r -> r.getElements().stream()).collect(ImmutableList.toImmutableList());
                ImmutableList inputRandomElements = (ImmutableList)input.get().stream().flatMap(r -> r.getRandomElementsInRoll().stream()).collect(ImmutableList.toImmutableList());
                for (int i = 1; i < arguments.size() - 1; i += 2) {
                    Optional<List<Roll>> inRolls = ((RollBuilder)arguments.get(i)).extendRoll(rollContext);
                    ValidatorUtil.checkContainsSingleRoll(expressionPosition, inRolls, i + 1);
                    Roll inRoll = inRolls.orElseThrow().getFirst();
                    allRolls.add((Object)inRoll);
                    Optional<List<Roll>> colorRolls = ((RollBuilder)arguments.get(i + 1)).extendRoll(rollContext);
                    ValidatorUtil.checkContainsSingleRoll(expressionPosition, colorRolls, i + 2);
                    Roll colorRoll = colorRolls.orElseThrow().getFirst();
                    ValidatorUtil.checkContainsNoOrSingleElement(expressionPosition, colorRoll, "%d argument".formatted(i + 2));
                    String color = colorRoll.asSingleValue().orElse("");
                    ImmutableList.Builder currentIterationElements = ImmutableList.builder();
                    for (RollElement rollElement : inputRollElements) {
                        if (inRoll.isElementsContainsElementWithValueAndTag(rollElement)) {
                            currentIterationElements.add((Object)new RollElement(rollElement.getValue(), rollElement.getTag(), color));
                            continue;
                        }
                        currentIterationElements.add((Object)rollElement);
                    }
                    inputRollElements = currentIterationElements.build();
                    ImmutableList.Builder currentIterationRandomElements = ImmutableList.builder();
                    for (RandomElement randomElement : inputRandomElements) {
                        if (inRoll.isElementsContainsElementWithValueAndTag(randomElement.getRollElement())) {
                            currentIterationRandomElements.add((Object)randomElement.copyWithTagAndColor(color));
                            continue;
                        }
                        currentIterationRandomElements.add((Object)randomElement);
                    }
                    inputRandomElements = currentIterationRandomElements.build();
                }
                RandomElementsBuilder builder = RandomElementsBuilder.empty(rollContext);
                builder.addRandomElements((Collection<RandomElement>)inputRandomElements);
                return Optional.of(ImmutableList.of((Object)new Roll(this.toExpression(), (ImmutableList<RollElement>)inputRollElements, builder.build(), (ImmutableList<Roll>)allRolls.build(), expressionPosition, ColorOn.this.maxNumberOfElements, ColorOn.this.keepChildrenRolls)));
            }

            @Override
            @NonNull
            public String toExpression() {
                return ColorOn.getExpression(expressionPosition, arguments);
            }
        };
    }
}

