/*
 * Decompiled with CFR 0.152.
 */
package de.janno.evaluator.dice.function;

import com.google.common.collect.ImmutableList;
import de.janno.evaluator.dice.ExpressionException;
import de.janno.evaluator.dice.ExpressionPosition;
import de.janno.evaluator.dice.Function;
import de.janno.evaluator.dice.RandomElementsBuilder;
import de.janno.evaluator.dice.Roll;
import de.janno.evaluator.dice.RollBuilder;
import de.janno.evaluator.dice.RollContext;
import de.janno.evaluator.dice.RollElement;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.NonNull;

public class ConcatFunction
extends Function {
    public ConcatFunction(int maxNumberOfElements, boolean keepChildrenRolls) {
        super("concat", 0, Integer.MAX_VALUE, maxNumberOfElements, keepChildrenRolls);
    }

    @Override
    @NonNull
    public RollBuilder evaluate(final @NonNull List<RollBuilder> arguments, final @NonNull ExpressionPosition expressionPosition) throws ExpressionException {
        if (arguments == null) {
            throw new NullPointerException("arguments is marked non-null but is null");
        }
        if (expressionPosition == null) {
            throw new NullPointerException("expressionPosition is marked non-null but is null");
        }
        return new RollBuilder(){

            @Override
            @NonNull
            public Optional<List<Roll>> extendRoll(@NonNull RollContext rollContext) throws ExpressionException {
                if (rollContext == null) {
                    throw new NullPointerException("rollContext is marked non-null but is null");
                }
                ImmutableList<Roll> rolls = RollBuilder.extendAllBuilder(arguments, rollContext);
                if (rolls.isEmpty()) {
                    return Optional.of(List.of());
                }
                String joined = rolls.stream().map(Roll::getResultString).collect(Collectors.joining());
                return Optional.of(ImmutableList.of((Object)new Roll(this.toExpression(), (ImmutableList<RollElement>)ImmutableList.of((Object)new RollElement(joined, "", "")), RandomElementsBuilder.fromRolls(rolls, rollContext), (ImmutableList<Roll>)ImmutableList.copyOf(rolls), expressionPosition, ConcatFunction.this.maxNumberOfElements, ConcatFunction.this.keepChildrenRolls)));
            }

            @Override
            @NonNull
            public String toExpression() {
                return ConcatFunction.getExpression(expressionPosition, arguments);
            }
        };
    }
}

