/*
 * Decompiled with CFR 0.152.
 */
package de.janno.evaluator.dice.function;

import com.google.common.collect.ImmutableList;
import de.janno.evaluator.dice.ExpressionException;
import de.janno.evaluator.dice.ExpressionPosition;
import de.janno.evaluator.dice.Function;
import de.janno.evaluator.dice.RandomElementsBuilder;
import de.janno.evaluator.dice.Roll;
import de.janno.evaluator.dice.RollBuilder;
import de.janno.evaluator.dice.RollContext;
import de.janno.evaluator.dice.RollElement;
import de.janno.evaluator.dice.ValidatorUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;

public class Explode
extends Function {
    public Explode(int maxNumberOfElements, boolean keepChildrenRolls) {
        super("exp", 2, 3, maxNumberOfElements, keepChildrenRolls);
    }

    @Override
    @NonNull
    public RollBuilder evaluate(final @NonNull List<RollBuilder> arguments, final @NonNull ExpressionPosition expressionPosition) throws ExpressionException {
        if (arguments == null) {
            throw new NullPointerException("arguments is marked non-null but is null");
        }
        if (expressionPosition == null) {
            throw new NullPointerException("expressionPosition is marked non-null but is null");
        }
        return new RollBuilder(){

            @Override
            @NonNull
            public Optional<List<Roll>> extendRoll(@NonNull RollContext rollContext) throws ExpressionException {
                int maxNumberOfRerolls;
                if (rollContext == null) {
                    throw new NullPointerException("rollContext is marked non-null but is null");
                }
                if (arguments.size() != 2 && arguments.size() != 3) {
                    throw new ExpressionException(String.format("'%s' requires 2 or 3 arguments but was %d", Explode.this.getName(), arguments.size()), expressionPosition);
                }
                ImmutableList.Builder allChildrenRollBuilder = ImmutableList.builder();
                ImmutableList.Builder rollExpression = ImmutableList.builder();
                RollBuilder inputRoll = (RollBuilder)arguments.getFirst();
                List firstRoll = inputRoll.extendRoll(rollContext).orElse(Collections.emptyList());
                rollExpression.addAll(firstRoll);
                allChildrenRollBuilder.addAll(firstRoll);
                Optional<List<Roll>> compareToRoll = ((RollBuilder)arguments.get(1)).extendRoll(rollContext);
                if (compareToRoll.isEmpty()) {
                    throw new ExpressionException(String.format("'%s' requires a non-empty input as second argument", expressionPosition.getValue()), expressionPosition);
                }
                ValidatorUtil.checkRollSize(expressionPosition, compareToRoll.get(), 1, 1);
                Roll compareTo = compareToRoll.get().getFirst();
                allChildrenRollBuilder.add((Object)compareTo);
                rollExpression.add((Object)compareTo);
                if (arguments.size() == 3) {
                    Optional<List<Roll>> maxRerollsRoll = ((RollBuilder)arguments.get(2)).extendRoll(rollContext);
                    if (maxRerollsRoll.isEmpty()) {
                        throw new ExpressionException(String.format("'%s' requires a non-empty input as third argument", expressionPosition.getValue()), expressionPosition);
                    }
                    ValidatorUtil.checkRollSize(expressionPosition, maxRerollsRoll.get(), 1, 1);
                    Roll maxNumberOfRerollsRoll = maxRerollsRoll.get().getFirst();
                    maxNumberOfRerolls = maxNumberOfRerollsRoll.asInteger().orElseThrow(() -> ValidatorUtil.throwNotIntegerExpression(expressionPosition, (Roll)((List)maxRerollsRoll.get()).getFirst(), "third argument"));
                    if (maxNumberOfRerolls > 100 || maxNumberOfRerolls < 0) {
                        throw new ExpressionException(String.format("'%s' requires as third argument a number between 0 and 100", expressionPosition.getValue()), expressionPosition);
                    }
                    allChildrenRollBuilder.add((Object)maxNumberOfRerollsRoll);
                    rollExpression.add((Object)maxNumberOfRerollsRoll);
                } else {
                    maxNumberOfRerolls = 100;
                }
                List lastRoll = firstRoll;
                ImmutableList.Builder allResultRollsBuilder = ImmutableList.builder();
                allResultRollsBuilder.addAll(firstRoll);
                for (int rerolls = 0; rerolls < maxNumberOfRerolls; ++rerolls) {
                    if (!lastRoll.stream().flatMap(r -> r.getElements().stream()).anyMatch(compareTo::isElementsContainsElementWithValueAndTag)) break;
                    lastRoll = inputRoll.extendRoll(rollContext).orElse(Collections.emptyList());
                    allResultRollsBuilder.addAll(lastRoll);
                    allChildrenRollBuilder.addAll(lastRoll);
                }
                ImmutableList allResultRolls = allResultRollsBuilder.build();
                return Optional.of(ImmutableList.of((Object)new Roll(this.toExpression(), (ImmutableList<RollElement>)((ImmutableList)allResultRolls.stream().flatMap(r -> r.getElements().stream()).collect(ImmutableList.toImmutableList())), RandomElementsBuilder.fromRolls((Collection<Roll>)allChildrenRollBuilder.build(), rollContext), (ImmutableList<Roll>)allChildrenRollBuilder.build(), expressionPosition, Explode.this.maxNumberOfElements, Explode.this.keepChildrenRolls)));
            }

            @Override
            @NonNull
            public String toExpression() {
                return Explode.getExpression(expressionPosition, arguments);
            }
        };
    }
}

