/*
 * Decompiled with CFR 0.152.
 */
package de.janno.evaluator.dice.function;

import com.google.common.collect.ImmutableList;
import de.janno.evaluator.dice.ExpressionException;
import de.janno.evaluator.dice.ExpressionPosition;
import de.janno.evaluator.dice.Function;
import de.janno.evaluator.dice.RandomElementsBuilder;
import de.janno.evaluator.dice.Roll;
import de.janno.evaluator.dice.RollBuilder;
import de.janno.evaluator.dice.RollContext;
import de.janno.evaluator.dice.RollElement;
import de.janno.evaluator.dice.ValidatorUtil;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;

public class GroupCount
extends Function {
    public GroupCount(int maxNumberOfElements, boolean keepChildrenRolls) {
        super("groupC", 1, Integer.MAX_VALUE, maxNumberOfElements, keepChildrenRolls);
    }

    @Override
    @NonNull
    public RollBuilder evaluate(final @NonNull List<RollBuilder> arguments, final @NonNull ExpressionPosition expressionPosition) throws ExpressionException {
        if (arguments == null) {
            throw new NullPointerException("arguments is marked non-null but is null");
        }
        if (expressionPosition == null) {
            throw new NullPointerException("expressionPosition is marked non-null but is null");
        }
        return new RollBuilder(){

            @Override
            @NonNull
            public Optional<List<Roll>> extendRoll(@NonNull RollContext rollContext) throws ExpressionException {
                if (rollContext == null) {
                    throw new NullPointerException("rollContext is marked non-null but is null");
                }
                ImmutableList<Roll> rolls = RollBuilder.extendAllBuilder(arguments, rollContext);
                ValidatorUtil.checkRollSize(expressionPosition, rolls, GroupCount.this.getMinArgumentCount(), GroupCount.this.getMaxArgumentCount());
                ImmutableList res = (ImmutableList)rolls.stream().flatMap(result -> result.getElements().stream()).collect(Collectors.groupingBy(e -> new ValueAndTag(e.getValue(), e.getTag()))).entrySet().stream().sorted(Comparator.comparingInt(o -> ((List)o.getValue()).size()).reversed()).map(groupedElements -> new RollElement("%dx%s".formatted(((List)groupedElements.getValue()).size(), ((ValueAndTag)groupedElements.getKey()).getValue()), ((ValueAndTag)groupedElements.getKey()).getTag(), "")).collect(ImmutableList.toImmutableList());
                return Optional.of(ImmutableList.of((Object)new Roll(this.toExpression(), (ImmutableList<RollElement>)res, RandomElementsBuilder.fromRolls(rolls, rollContext), (ImmutableList<Roll>)ImmutableList.copyOf(rolls), expressionPosition, GroupCount.this.maxNumberOfElements, GroupCount.this.keepChildrenRolls)));
            }

            @Override
            @NonNull
            public String toExpression() {
                return GroupCount.getExpression(expressionPosition, arguments);
            }
        };
    }

    private static final class ValueAndTag {
        private final String value;
        private final String tag;

        @Generated
        public ValueAndTag(String value, String tag) {
            this.value = value;
            this.tag = tag;
        }

        @Generated
        public String getValue() {
            return this.value;
        }

        @Generated
        public String getTag() {
            return this.tag;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ValueAndTag)) {
                return false;
            }
            ValueAndTag other = (ValueAndTag)o;
            String this$value = this.getValue();
            String other$value = other.getValue();
            if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
                return false;
            }
            String this$tag = this.getTag();
            String other$tag = other.getTag();
            return !(this$tag == null ? other$tag != null : !this$tag.equals(other$tag));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            String $tag = this.getTag();
            result = result * 59 + ($tag == null ? 43 : $tag.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "GroupCount.ValueAndTag(value=" + this.getValue() + ", tag=" + this.getTag() + ")";
        }
    }
}

