/*
 * Decompiled with CFR 0.152.
 */
package de.janno.evaluator.dice.function;

import com.google.common.collect.ImmutableList;
import de.janno.evaluator.dice.ExpressionException;
import de.janno.evaluator.dice.ExpressionPosition;
import de.janno.evaluator.dice.Function;
import de.janno.evaluator.dice.RandomElementsBuilder;
import de.janno.evaluator.dice.Roll;
import de.janno.evaluator.dice.RollBuilder;
import de.janno.evaluator.dice.RollContext;
import de.janno.evaluator.dice.ValidatorUtil;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;

public class If
extends Function {
    public If(int maxNumberOfElements, boolean keepChildrenRolls) {
        super("if", 1, Integer.MAX_VALUE, maxNumberOfElements, keepChildrenRolls);
    }

    @Override
    @NonNull
    public RollBuilder evaluate(final @NonNull List<RollBuilder> arguments, final @NonNull ExpressionPosition expressionPosition) throws ExpressionException {
        if (arguments == null) {
            throw new NullPointerException("arguments is marked non-null but is null");
        }
        if (expressionPosition == null) {
            throw new NullPointerException("expressionPosition is marked non-null but is null");
        }
        return new RollBuilder(){

            @Override
            @NonNull
            public Optional<List<Roll>> extendRoll(@NonNull RollContext rollContext) throws ExpressionException {
                Optional<List<Roll>> defaultResult;
                if (rollContext == null) {
                    throw new NullPointerException("rollContext is marked non-null but is null");
                }
                if (arguments.size() < 2) {
                    throw new ExpressionException(String.format("'%s' requires as 2 inputs but was '%s'", If.this.getName(), arguments.size()), expressionPosition);
                }
                ImmutableList.Builder allRolls = ImmutableList.builder();
                Optional<List<Roll>> checkIfTrue = ((RollBuilder)arguments.getFirst()).extendRoll(rollContext);
                if (checkIfTrue.isEmpty()) {
                    throw new ExpressionException(String.format("'%s' requires a non-empty input as first argument", expressionPosition.getValue()), expressionPosition);
                }
                RandomElementsBuilder booleanRandomElements = RandomElementsBuilder.empty(rollContext);
                RollContext trueContext = rollContext.copy();
                Optional<List<Roll>> returnIfTrue = ((RollBuilder)arguments.get(1)).extendRoll(trueContext);
                int checkIfTrueIndex = 1;
                while (checkIfTrueIndex < arguments.size()) {
                    if (checkIfTrue.isEmpty()) {
                        throw new ExpressionException(String.format("'%s' requires a non-empty input as %s argument", expressionPosition.getValue(), checkIfTrueIndex), expressionPosition);
                    }
                    ValidatorUtil.checkRollSize(expressionPosition, checkIfTrue.get(), 1, 1);
                    Roll booleanExpression = checkIfTrue.get().getFirst();
                    allRolls.addAll((Iterable)checkIfTrue.get());
                    allRolls.addAll((Iterable)returnIfTrue.orElse(Collections.emptyList()));
                    int booleanArgumentIndex = checkIfTrueIndex;
                    boolean booleanValue = booleanExpression.asBoolean().orElseThrow(() -> ValidatorUtil.throwNotBoolean(expressionPosition, booleanExpression, "position %d".formatted(booleanArgumentIndex)));
                    booleanRandomElements.addRoll(booleanExpression);
                    if (booleanValue) {
                        List trueResult = returnIfTrue.orElse(Collections.emptyList());
                        rollContext.merge(trueContext);
                        ImmutableList.Builder resultBuilder = ImmutableList.builder();
                        for (Roll r : trueResult) {
                            resultBuilder.add((Object)new Roll(this.toExpression(), r.getElements(), booleanRandomElements.addRoll(r).build(), (ImmutableList<Roll>)ImmutableList.builder().addAll(booleanExpression.getChildrenRolls()).addAll(r.getChildrenRolls()).build(), expressionPosition, If.this.maxNumberOfElements, If.this.keepChildrenRolls));
                        }
                        return Optional.of(resultBuilder.build());
                    }
                    if ((checkIfTrueIndex += 2) < arguments.size()) {
                        checkIfTrue = ((RollBuilder)arguments.get(checkIfTrueIndex - 1)).extendRoll(rollContext);
                        trueContext = rollContext.copy();
                        returnIfTrue = ((RollBuilder)arguments.get(checkIfTrueIndex)).extendRoll(trueContext);
                        continue;
                    }
                    checkIfTrue = Optional.empty();
                    returnIfTrue = Optional.empty();
                }
                if (checkIfTrueIndex == arguments.size() && (defaultResult = ((RollBuilder)arguments.get(checkIfTrueIndex - 1)).extendRoll(rollContext)).isPresent()) {
                    allRolls.addAll((Iterable)defaultResult.get());
                    ImmutableList.Builder resultBuilder = ImmutableList.builder();
                    for (Roll r : defaultResult.get()) {
                        resultBuilder.add((Object)new Roll(this.toExpression(), r.getElements(), booleanRandomElements.addRoll(r).build(), r.getChildrenRolls(), expressionPosition, If.this.maxNumberOfElements, If.this.keepChildrenRolls));
                    }
                    return Optional.of(resultBuilder.build());
                }
                return Optional.empty();
            }

            @Override
            @NonNull
            public String toExpression() {
                return If.getExpression(expressionPosition, arguments);
            }
        };
    }
}

