/*
 * Decompiled with CFR 0.152.
 */
package de.janno.evaluator.dice.function;

import com.google.common.collect.ImmutableList;
import de.janno.evaluator.dice.ExpressionException;
import de.janno.evaluator.dice.ExpressionPosition;
import de.janno.evaluator.dice.Function;
import de.janno.evaluator.dice.RandomElementsBuilder;
import de.janno.evaluator.dice.Roll;
import de.janno.evaluator.dice.RollBuilder;
import de.janno.evaluator.dice.RollContext;
import de.janno.evaluator.dice.RollElement;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;

public class Replace
extends Function {
    public Replace(int maxNumberOfElements, boolean keepChildrenRolls) {
        super("replace", 3, Integer.MAX_VALUE, maxNumberOfElements, keepChildrenRolls);
    }

    @Override
    @NonNull
    public RollBuilder evaluate(final @NonNull List<RollBuilder> arguments, final @NonNull ExpressionPosition expressionPosition) throws ExpressionException {
        if (arguments == null) {
            throw new NullPointerException("arguments is marked non-null but is null");
        }
        if (expressionPosition == null) {
            throw new NullPointerException("expressionPosition is marked non-null but is null");
        }
        return new RollBuilder(){

            @Override
            @NonNull
            public Optional<List<Roll>> extendRoll(@NonNull RollContext rollContext) throws ExpressionException {
                if (rollContext == null) {
                    throw new NullPointerException("rollContext is marked non-null but is null");
                }
                if (arguments.size() % 2 == 0) {
                    throw new ExpressionException(String.format("'%s' requires an odd number of arguments but was %d", Replace.this.getName(), arguments.size()), expressionPosition);
                }
                Optional<List<Roll>> input = ((RollBuilder)arguments.getFirst()).extendRoll(rollContext);
                if (input.isEmpty()) {
                    throw new ExpressionException(String.format("'%s' requires a non-empty input as first argument", expressionPosition.getValue()), expressionPosition);
                }
                ImmutableList.Builder allRolls = ImmutableList.builder();
                ImmutableList.Builder rollExpression = ImmutableList.builder();
                allRolls.addAll((Iterable)input.get());
                rollExpression.addAll((Iterable)input.get());
                ImmutableList rollElements = (ImmutableList)input.get().stream().flatMap(r -> r.getElements().stream()).collect(ImmutableList.toImmutableList());
                ImmutableList.Builder childrenRollBuilder = ImmutableList.builder().addAll((Iterable)input.get());
                for (int i = 1; i < arguments.size() - 1; i += 2) {
                    Optional<List<Roll>> find = ((RollBuilder)arguments.get(i)).extendRoll(rollContext);
                    find.ifPresent(arg_0 -> ((ImmutableList.Builder)allRolls).addAll(arg_0));
                    if (!find.isPresent() || !rollElements.stream().anyMatch(r -> ((List)find.get()).stream().anyMatch(f -> f.isElementsContainsElementWithValueAndTag((RollElement)r)))) continue;
                    childrenRollBuilder.addAll((Iterable)find.get());
                    RollBuilder replaceArgument = (RollBuilder)arguments.get(i + 1);
                    ImmutableList.Builder newRollElementsList = ImmutableList.builder();
                    for (RollElement r2 : rollElements) {
                        if (find.get().stream().anyMatch(f -> f.isElementsContainsElementWithValueAndTag(r2))) {
                            Optional<List<Roll>> replace = replaceArgument.extendRoll(rollContext);
                            replace.ifPresent(arg_0 -> ((ImmutableList.Builder)allRolls).addAll(arg_0));
                            if (replace.isPresent()) {
                                childrenRollBuilder.addAll((Iterable)replace.get());
                                newRollElementsList.addAll(replace.get().stream().flatMap(re -> re.getElements().stream()).toList());
                                continue;
                            }
                            newRollElementsList.add((Object)r2);
                            continue;
                        }
                        newRollElementsList.add((Object)r2);
                    }
                    rollElements = newRollElementsList.build();
                }
                return Optional.of(ImmutableList.of((Object)new Roll(this.toExpression(), (ImmutableList<RollElement>)rollElements, RandomElementsBuilder.fromRolls((Collection<Roll>)allRolls.build(), rollContext), (ImmutableList<Roll>)childrenRollBuilder.build(), expressionPosition, Replace.this.maxNumberOfElements, Replace.this.keepChildrenRolls)));
            }

            @Override
            @NonNull
            public String toExpression() {
                return Replace.getExpression(expressionPosition, arguments);
            }
        };
    }
}

