/*
 * Decompiled with CFR 0.152.
 */
package de.janno.evaluator.dice.function;

import com.google.common.collect.ImmutableList;
import de.janno.evaluator.dice.ExpressionException;
import de.janno.evaluator.dice.ExpressionPosition;
import de.janno.evaluator.dice.Function;
import de.janno.evaluator.dice.RandomElementsBuilder;
import de.janno.evaluator.dice.Roll;
import de.janno.evaluator.dice.RollBuilder;
import de.janno.evaluator.dice.RollContext;
import de.janno.evaluator.dice.RollElement;
import de.janno.evaluator.dice.ValidatorUtil;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;

public class SortDesc
extends Function {
    public SortDesc(int maxNumberOfElements, boolean keepChildrenRolls) {
        super("desc", 1, Integer.MAX_VALUE, maxNumberOfElements, keepChildrenRolls);
    }

    @Override
    @NonNull
    public RollBuilder evaluate(final @NonNull List<RollBuilder> arguments, final @NonNull ExpressionPosition expressionPosition) throws ExpressionException {
        if (arguments == null) {
            throw new NullPointerException("arguments is marked non-null but is null");
        }
        if (expressionPosition == null) {
            throw new NullPointerException("expressionPosition is marked non-null but is null");
        }
        return new RollBuilder(){

            @Override
            @NonNull
            public Optional<List<Roll>> extendRoll(@NonNull RollContext rollContext) throws ExpressionException {
                if (rollContext == null) {
                    throw new NullPointerException("rollContext is marked non-null but is null");
                }
                ImmutableList<Roll> rolls = RollBuilder.extendAllBuilder(arguments, rollContext);
                ValidatorUtil.checkRollSize(expressionPosition, rolls, SortDesc.this.getMinArgumentCount(), SortDesc.this.getMaxArgumentCount());
                ImmutableList res = (ImmutableList)rolls.stream().flatMap(result -> result.getElements().stream()).sorted(Comparator.reverseOrder()).collect(ImmutableList.toImmutableList());
                return Optional.of(ImmutableList.of((Object)new Roll(this.toExpression(), (ImmutableList<RollElement>)res, RandomElementsBuilder.fromRolls(rolls, rollContext), (ImmutableList<Roll>)ImmutableList.copyOf(rolls), expressionPosition, SortDesc.this.maxNumberOfElements, SortDesc.this.keepChildrenRolls)));
            }

            @Override
            @NonNull
            public String toExpression() {
                return SortDesc.getExpression(expressionPosition, arguments);
            }
        };
    }
}

