/*
 * Decompiled with CFR 0.152.
 */
package de.janno.evaluator.dice.function;

import com.google.common.collect.ImmutableList;
import de.janno.evaluator.dice.ExpressionException;
import de.janno.evaluator.dice.ExpressionPosition;
import de.janno.evaluator.dice.Function;
import de.janno.evaluator.dice.RandomElementsBuilder;
import de.janno.evaluator.dice.Roll;
import de.janno.evaluator.dice.RollBuilder;
import de.janno.evaluator.dice.RollContext;
import de.janno.evaluator.dice.ValidatorUtil;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;

public class Value
extends Function {
    public Value(int maxNumberOfElements, boolean keepChildrenRolls) {
        super("val", 2, maxNumberOfElements, keepChildrenRolls);
    }

    @Override
    @NonNull
    public RollBuilder evaluate(final @NonNull List<RollBuilder> arguments, final @NonNull ExpressionPosition expressionPosition) throws ExpressionException {
        if (arguments == null) {
            throw new NullPointerException("arguments is marked non-null but is null");
        }
        if (expressionPosition == null) {
            throw new NullPointerException("expressionPosition is marked non-null but is null");
        }
        return new RollBuilder(){

            @Override
            @NonNull
            public Optional<List<Roll>> extendRoll(@NonNull RollContext rollContext) throws ExpressionException {
                if (rollContext == null) {
                    throw new NullPointerException("rollContext is marked non-null but is null");
                }
                RollContext nameContext = rollContext.copyWithEmptyVariables();
                Optional<List<Roll>> valNameRoll = ((RollBuilder)arguments.getFirst()).extendRoll(nameContext);
                if (valNameRoll.isEmpty()) {
                    throw new ExpressionException(String.format("'%s' requires a non-empty input as first argument", expressionPosition.getValue()), expressionPosition);
                }
                ImmutableList.Builder rollBuilder = ImmutableList.builder().addAll((Iterable)valNameRoll.get());
                rollContext.merge(nameContext);
                List<RollBuilder> remainingRollBuilder = arguments.subList(1, arguments.size());
                ImmutableList<Roll> remainingRolls = RollBuilder.extendAllBuilder(remainingRollBuilder, rollContext);
                ImmutableList rolls = rollBuilder.addAll(remainingRolls).build();
                ValidatorUtil.checkRollSize(expressionPosition, (List<Roll>)rolls, Value.this.getMinArgumentCount(), Value.this.getMaxArgumentCount());
                if (((Roll)rolls.getFirst()).getElements().isEmpty()) {
                    throw new ExpressionException(String.format("'%s' requires a non-empty input as first argument", expressionPosition.getValue()), expressionPosition);
                }
                String valName = ((Roll)rolls.getFirst()).asSingleValue().orElseThrow();
                String expression = this.toExpression();
                rollContext.putVariable(valName, new Roll(expression, ((Roll)rolls.get(1)).getElements(), RandomElementsBuilder.fromRolls((Collection<Roll>)rolls, rollContext), ((Roll)rolls.get(1)).getChildrenRolls(), expressionPosition, Value.this.maxNumberOfElements, Value.this.keepChildrenRolls));
                return Optional.empty();
            }

            @Override
            @NonNull
            public String toExpression() {
                return Value.getExpression(expressionPosition, arguments);
            }
        };
    }
}

