/*
 * Decompiled with CFR 0.152.
 */
package de.janno.evaluator.dice.operator.die;

import com.google.common.collect.ImmutableList;
import de.janno.evaluator.dice.ExpressionException;
import de.janno.evaluator.dice.ExpressionPosition;
import de.janno.evaluator.dice.Operator;
import de.janno.evaluator.dice.RandomElementsBuilder;
import de.janno.evaluator.dice.Roll;
import de.janno.evaluator.dice.RollBuilder;
import de.janno.evaluator.dice.RollContext;
import de.janno.evaluator.dice.RollElement;
import de.janno.evaluator.dice.ValidatorUtil;
import de.janno.evaluator.dice.operator.OperatorOrder;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;

public class Color
extends Operator {
    public Color(int maxNumberOfElements, boolean keepChildrenRolls) {
        super("col", Operator.OperatorType.BINARY, Operator.Associativity.LEFT, OperatorOrder.getOderNumberOf(Color.class), maxNumberOfElements, keepChildrenRolls);
    }

    @Override
    @NonNull
    public RollBuilder evaluate(final @NonNull List<RollBuilder> operands, final @NonNull ExpressionPosition expressionPosition) throws ExpressionException {
        if (operands == null) {
            throw new NullPointerException("operands is marked non-null but is null");
        }
        if (expressionPosition == null) {
            throw new NullPointerException("expressionPosition is marked non-null but is null");
        }
        return new RollBuilder(){

            @Override
            @NonNull
            public Optional<List<Roll>> extendRoll(@NonNull RollContext rollContext) throws ExpressionException {
                if (rollContext == null) {
                    throw new NullPointerException("rollContext is marked non-null but is null");
                }
                ImmutableList<Roll> rolls = RollBuilder.extendAllBuilder(operands, rollContext);
                ValidatorUtil.checkRollSize(expressionPosition, rolls, 2, 2);
                Roll left = (Roll)rolls.getFirst();
                Roll right = (Roll)rolls.get(1);
                ValidatorUtil.checkAllElementsAreSameTag(expressionPosition, left, right);
                ValidatorUtil.checkContainsSingleElement(expressionPosition, right, "second argument");
                String color = right.asSingleValue().orElseThrow();
                RandomElementsBuilder builder = RandomElementsBuilder.empty(rollContext);
                rolls.forEach(r -> builder.addWithColor((Roll)r, color));
                return Optional.of(ImmutableList.of((Object)new Roll(this.toExpression(), (ImmutableList<RollElement>)((ImmutableList)left.getElements().stream().map(r -> new RollElement(r.getValue(), r.getTag(), color)).collect(ImmutableList.toImmutableList())), builder.build(), (ImmutableList<Roll>)ImmutableList.of((Object)left, (Object)right), expressionPosition, Color.this.maxNumberOfElements, Color.this.keepChildrenRolls)));
            }

            @Override
            @NonNull
            public String toExpression() {
                return Color.getBinaryOperatorExpression(expressionPosition, operands);
            }
        };
    }
}

