/*
 * Decompiled with CFR 0.152.
 */
package de.janno.evaluator.dice.operator.die;

import com.google.common.collect.ImmutableList;
import de.janno.evaluator.dice.DiceHelper;
import de.janno.evaluator.dice.ExpressionException;
import de.janno.evaluator.dice.ExpressionPosition;
import de.janno.evaluator.dice.Operator;
import de.janno.evaluator.dice.RandomElement;
import de.janno.evaluator.dice.RandomElementsBuilder;
import de.janno.evaluator.dice.Roll;
import de.janno.evaluator.dice.RollBuilder;
import de.janno.evaluator.dice.RollContext;
import de.janno.evaluator.dice.RollElement;
import de.janno.evaluator.dice.RollId;
import de.janno.evaluator.dice.ValidatorUtil;
import de.janno.evaluator.dice.operator.OperatorOrder;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;

public final class ExplodingDice
extends Operator {
    private final int maxNumberOfDice;

    public ExplodingDice(int maxNumberOfDice, int maxNumberOfElements, boolean keepChildrenRolls) {
        super("d!", Operator.Associativity.RIGHT, OperatorOrder.getOderNumberOf(ExplodingDice.class), Operator.Associativity.LEFT, OperatorOrder.getOderNumberOf(ExplodingDice.class), maxNumberOfElements, keepChildrenRolls);
        this.maxNumberOfDice = maxNumberOfDice;
    }

    @Override
    @NonNull
    public RollBuilder evaluate(final @NonNull List<RollBuilder> operands, final @NonNull ExpressionPosition expressionPosition) throws ExpressionException {
        if (operands == null) {
            throw new NullPointerException("operands is marked non-null but is null");
        }
        if (expressionPosition == null) {
            throw new NullPointerException("expressionPosition is marked non-null but is null");
        }
        return new RollBuilder(){

            @Override
            @NonNull
            public Optional<List<Roll>> extendRoll(@NonNull RollContext rollContext) throws ExpressionException {
                ImmutableList childrenRolls;
                int sidesOfDie;
                int numberOfDice;
                if (rollContext == null) {
                    throw new NullPointerException("rollContext is marked non-null but is null");
                }
                ImmutableList<Roll> rolls = RollBuilder.extendAllBuilder(operands, rollContext);
                ValidatorUtil.checkRollSize(expressionPosition, rolls, 1, 2);
                RandomElementsBuilder randomElements = RandomElementsBuilder.empty(rollContext);
                RollId rollId = RollId.of(expressionPosition, rollContext.getNextReEvaluationNumber(expressionPosition));
                if (rolls.size() == 1) {
                    numberOfDice = 1;
                    Roll right = (Roll)rolls.getFirst();
                    sidesOfDie = right.asInteger().orElseThrow(() -> ValidatorUtil.throwNotIntegerExpression(expressionPosition, right, "right"));
                    childrenRolls = ImmutableList.of((Object)right);
                    randomElements.addRoll(right);
                } else {
                    Roll left = (Roll)rolls.getFirst();
                    Roll right = (Roll)rolls.get(1);
                    randomElements.addRoll(left);
                    randomElements.addRoll(right);
                    numberOfDice = left.asInteger().orElseThrow(() -> ValidatorUtil.throwNotIntegerExpression(expressionPosition, left, "left"));
                    sidesOfDie = right.asInteger().orElseThrow(() -> ValidatorUtil.throwNotIntegerExpression(expressionPosition, right, "right"));
                    childrenRolls = ImmutableList.of((Object)left, (Object)right);
                }
                if (numberOfDice > ExplodingDice.this.maxNumberOfDice) {
                    throw new ExpressionException(String.format("The number of dice must be less or equal then %d but was %d", ExplodingDice.this.maxNumberOfDice, numberOfDice), expressionPosition);
                }
                if (numberOfDice < 0) {
                    throw new ExpressionException(String.format("The number of dice can not be negativ but was %d", numberOfDice), expressionPosition);
                }
                if (sidesOfDie < 2) {
                    throw new ExpressionException(String.format("The number of sides of a die must be greater then 1 but was %d", sidesOfDie), expressionPosition);
                }
                ImmutableList<RandomElement> roll = DiceHelper.explodingDice(numberOfDice, sidesOfDie, rollContext.getNumberSupplier(), rollId, ExplodingDice.this.maxNumberOfElements, this.toExpression());
                ImmutableList rollElements = (ImmutableList)roll.stream().map(RandomElement::getRollElement).collect(ImmutableList.toImmutableList());
                return Optional.of(ImmutableList.of((Object)new Roll(this.toExpression(), (ImmutableList<RollElement>)rollElements, randomElements.addRandomElements((Collection<RandomElement>)roll).build(), (ImmutableList<Roll>)childrenRolls, expressionPosition, ExplodingDice.this.maxNumberOfElements, ExplodingDice.this.keepChildrenRolls)));
            }

            @Override
            @NonNull
            public String toExpression() {
                if (operands.size() == 1) {
                    return ExplodingDice.getRightUnaryExpression(expressionPosition, operands);
                }
                return ExplodingDice.getBinaryOperatorExpression(expressionPosition, operands);
            }
        };
    }
}

