/*
 * Decompiled with CFR 0.152.
 */
package de.janno.evaluator.dice.operator.die;

import com.google.common.collect.ImmutableList;
import de.janno.evaluator.dice.DiceHelper;
import de.janno.evaluator.dice.DieId;
import de.janno.evaluator.dice.ExpressionException;
import de.janno.evaluator.dice.ExpressionPosition;
import de.janno.evaluator.dice.Operator;
import de.janno.evaluator.dice.RandomElement;
import de.janno.evaluator.dice.RandomElementsBuilder;
import de.janno.evaluator.dice.Roll;
import de.janno.evaluator.dice.RollBuilder;
import de.janno.evaluator.dice.RollContext;
import de.janno.evaluator.dice.RollElement;
import de.janno.evaluator.dice.RollId;
import de.janno.evaluator.dice.ValidatorUtil;
import de.janno.evaluator.dice.operator.OperatorOrder;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;

public final class RegularDice
extends Operator {
    private final int maxNumberOfDice;

    public RegularDice(int maxNumberOfDice, int maxNumberOfElements, boolean keepChildrenRolls) {
        super("d", Operator.Associativity.RIGHT, OperatorOrder.getOderNumberOf(RegularDice.class), Operator.Associativity.LEFT, OperatorOrder.getOderNumberOf(RegularDice.class), maxNumberOfElements, keepChildrenRolls);
        this.maxNumberOfDice = maxNumberOfDice;
    }

    @Override
    @NonNull
    public RollBuilder evaluate(final @NonNull List<RollBuilder> operands, final @NonNull ExpressionPosition expressionPosition) throws ExpressionException {
        if (operands == null) {
            throw new NullPointerException("operands is marked non-null but is null");
        }
        if (expressionPosition == null) {
            throw new NullPointerException("expressionPosition is marked non-null but is null");
        }
        return new RollBuilder(){

            @Override
            @NonNull
            public Optional<List<Roll>> extendRoll(@NonNull RollContext rollContext) throws ExpressionException {
                ImmutableList rollElements;
                String expression;
                ImmutableList childrenRolls;
                int numberOfDice;
                Roll right;
                if (rollContext == null) {
                    throw new NullPointerException("rollContext is marked non-null but is null");
                }
                ImmutableList<Roll> rolls = RollBuilder.extendAllBuilder(operands, rollContext);
                ValidatorUtil.checkRollSize(expressionPosition, rolls, 1, 2);
                RollId rollId = RollId.of(expressionPosition, rollContext.getNextReEvaluationNumber(expressionPosition));
                RandomElementsBuilder randomElements = RandomElementsBuilder.empty(rollContext);
                if (rolls.size() == 1) {
                    right = (Roll)rolls.getFirst();
                    randomElements.addRoll(right);
                    numberOfDice = 1;
                    childrenRolls = ImmutableList.of((Object)right);
                    expression = this.toExpression();
                } else if (rolls.size() == 2) {
                    Roll left = (Roll)rolls.getFirst();
                    right = (Roll)rolls.get(1);
                    childrenRolls = ImmutableList.of((Object)left, (Object)right);
                    numberOfDice = left.asInteger().orElseThrow(() -> ValidatorUtil.throwNotIntegerExpression(expressionPosition, left, "left"));
                    expression = this.toExpression();
                    randomElements.addRoll(left);
                    randomElements.addRoll(right);
                } else {
                    throw new IllegalStateException("More then two operands for " + expressionPosition.getValue());
                }
                if (numberOfDice > RegularDice.this.maxNumberOfDice) {
                    throw new ExpressionException(String.format("The number of dice must be less or equal then %d but was %d", RegularDice.this.maxNumberOfDice, numberOfDice), expressionPosition);
                }
                if (numberOfDice < 0) {
                    throw new ExpressionException(String.format("The number of dice can not be negativ but was %d", numberOfDice), expressionPosition);
                }
                if (right.asInteger().isPresent()) {
                    int sidesOfDie = right.asInteger().get();
                    ImmutableList<RandomElement> roll = DiceHelper.rollDice(numberOfDice, sidesOfDie, rollContext.getNumberSupplier(), rollId);
                    rollElements = (ImmutableList)roll.stream().map(RandomElement::getRollElement).collect(ImmutableList.toImmutableList());
                    randomElements.addRandomElements((Collection<RandomElement>)roll);
                } else {
                    ImmutableList.Builder rollBuilder = ImmutableList.builder();
                    for (int i = 0; i < numberOfDice; ++i) {
                        rollBuilder.add((Object)DiceHelper.pickOneOf(right.getElements(), rollContext.getNumberSupplier(), DieId.of(rollId, i, 0)));
                    }
                    ImmutableList roll = rollBuilder.build();
                    rollElements = (ImmutableList)roll.stream().map(RandomElement::getRollElement).collect(ImmutableList.toImmutableList());
                    randomElements.addRandomElements((Collection<RandomElement>)roll);
                }
                return Optional.of(ImmutableList.of((Object)new Roll(expression, (ImmutableList<RollElement>)rollElements, randomElements.build(), (ImmutableList<Roll>)childrenRolls, expressionPosition, RegularDice.this.maxNumberOfElements, RegularDice.this.keepChildrenRolls)));
            }

            @Override
            @NonNull
            public String toExpression() {
                if (operands.size() == 1) {
                    return RegularDice.getRightUnaryExpression(expressionPosition, operands);
                }
                return RegularDice.getBinaryOperatorExpression(expressionPosition, operands);
            }
        };
    }
}

