/*
 * Decompiled with CFR 0.152.
 */
package de.janno.evaluator.dice.operator.die;

import com.google.common.collect.ImmutableList;
import de.janno.evaluator.dice.ExpressionException;
import de.janno.evaluator.dice.ExpressionPosition;
import de.janno.evaluator.dice.Operator;
import de.janno.evaluator.dice.RandomElementsBuilder;
import de.janno.evaluator.dice.Roll;
import de.janno.evaluator.dice.RollBuilder;
import de.janno.evaluator.dice.RollContext;
import de.janno.evaluator.dice.ValidatorUtil;
import de.janno.evaluator.dice.operator.OperatorOrder;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;

public class Reroll
extends Operator {
    public Reroll(int maxNumberOfElements, boolean keepChildrenRolls) {
        super("rr", Operator.OperatorType.BINARY, Operator.Associativity.LEFT, OperatorOrder.getOderNumberOf(Reroll.class), maxNumberOfElements, keepChildrenRolls);
    }

    @Override
    @NonNull
    public RollBuilder evaluate(final @NonNull List<RollBuilder> operands, final @NonNull ExpressionPosition expressionPosition) throws ExpressionException {
        if (operands == null) {
            throw new NullPointerException("operands is marked non-null but is null");
        }
        if (expressionPosition == null) {
            throw new NullPointerException("expressionPosition is marked non-null but is null");
        }
        return new RollBuilder(){

            @Override
            @NonNull
            public Optional<List<Roll>> extendRoll(@NonNull RollContext rollContext) throws ExpressionException {
                if (rollContext == null) {
                    throw new NullPointerException("rollContext is marked non-null but is null");
                }
                RollBuilder inputBuilder = (RollBuilder)operands.getFirst();
                List<Roll> compareTos = ((RollBuilder)operands.get(1)).extendRoll(rollContext).orElse(Collections.emptyList());
                ValidatorUtil.checkRollSize(expressionPosition, compareTos, 1, 1);
                Roll compareTo = compareTos.getFirst();
                List<Roll> rolls = inputBuilder.extendRoll(rollContext).orElse(Collections.emptyList());
                ValidatorUtil.checkRollSize(expressionPosition, rolls, 1, 1);
                Roll roll = rolls.getFirst();
                RandomElementsBuilder builder = RandomElementsBuilder.ofRoll(roll, rollContext).addRoll(compareTo);
                if (roll.getElements().stream().anyMatch(compareTo::isElementsContainsElementWithValueAndTag)) {
                    rolls = inputBuilder.extendRoll(rollContext).orElse(Collections.emptyList());
                    ValidatorUtil.checkRollSize(expressionPosition, rolls, 1, 1);
                    roll = rolls.getFirst();
                    builder.addRoll(roll);
                }
                return Optional.of(ImmutableList.of((Object)new Roll(this.toExpression(), roll.getElements(), builder.build(), (ImmutableList<Roll>)ImmutableList.builder().addAll(compareTo.getChildrenRolls()).addAll(roll.getChildrenRolls()).build(), expressionPosition, Reroll.this.maxNumberOfElements, Reroll.this.keepChildrenRolls)));
            }

            @Override
            @NonNull
            public String toExpression() {
                return Reroll.getBinaryOperatorExpression(expressionPosition, operands);
            }
        };
    }
}

