/*
 * Decompiled with CFR 0.152.
 */
package de.janno.evaluator.dice.operator.die;

import com.google.common.collect.ImmutableList;
import de.janno.evaluator.dice.ExpressionException;
import de.janno.evaluator.dice.ExpressionPosition;
import de.janno.evaluator.dice.Operator;
import de.janno.evaluator.dice.RandomElementsBuilder;
import de.janno.evaluator.dice.Roll;
import de.janno.evaluator.dice.RollBuilder;
import de.janno.evaluator.dice.RollContext;
import de.janno.evaluator.dice.RollElement;
import de.janno.evaluator.dice.ValidatorUtil;
import de.janno.evaluator.dice.operator.OperatorOrder;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;

public class Tag
extends Operator {
    public Tag(int maxNumberOfElements, boolean keepChildrenRolls) {
        super("tag", Operator.OperatorType.BINARY, Operator.Associativity.LEFT, OperatorOrder.getOderNumberOf(Tag.class), maxNumberOfElements, keepChildrenRolls);
    }

    @Override
    @NonNull
    public RollBuilder evaluate(final @NonNull List<RollBuilder> operands, final @NonNull ExpressionPosition expressionPosition) throws ExpressionException {
        if (operands == null) {
            throw new NullPointerException("operands is marked non-null but is null");
        }
        if (expressionPosition == null) {
            throw new NullPointerException("expressionPosition is marked non-null but is null");
        }
        return new RollBuilder(){

            @Override
            @NonNull
            public Optional<List<Roll>> extendRoll(@NonNull RollContext rollContext) throws ExpressionException {
                if (rollContext == null) {
                    throw new NullPointerException("rollContext is marked non-null but is null");
                }
                ImmutableList<Roll> rolls = RollBuilder.extendAllBuilder(operands, rollContext);
                ValidatorUtil.checkRollSize(expressionPosition, rolls, 2, 2);
                Roll left = (Roll)rolls.getFirst();
                Roll right = (Roll)rolls.get(1);
                ValidatorUtil.checkAllElementsAreSameTag(expressionPosition, left, right);
                ValidatorUtil.checkContainsSingleElement(expressionPosition, right, "second argument");
                String tag = right.asSingleValue().orElseThrow();
                return Optional.of(ImmutableList.of((Object)new Roll(this.toExpression(), (ImmutableList<RollElement>)((ImmutableList)left.getElements().stream().map(r -> new RollElement(r.getValue(), tag, r.getColor())).collect(ImmutableList.toImmutableList())), RandomElementsBuilder.fromRolls(rolls, rollContext), (ImmutableList<Roll>)ImmutableList.of((Object)left, (Object)right), expressionPosition, Tag.this.maxNumberOfElements, Tag.this.keepChildrenRolls)));
            }

            @Override
            @NonNull
            public String toExpression() {
                return Tag.getBinaryOperatorExpression(expressionPosition, operands);
            }
        };
    }
}

