/*
 * Decompiled with CFR 0.152.
 */
package de.janno.evaluator.dice.operator.list;

import com.google.common.collect.ImmutableList;
import de.janno.evaluator.dice.ExpressionException;
import de.janno.evaluator.dice.ExpressionPosition;
import de.janno.evaluator.dice.Operator;
import de.janno.evaluator.dice.RandomElementsBuilder;
import de.janno.evaluator.dice.Roll;
import de.janno.evaluator.dice.RollBuilder;
import de.janno.evaluator.dice.RollContext;
import de.janno.evaluator.dice.RollElement;
import de.janno.evaluator.dice.ValidatorUtil;
import de.janno.evaluator.dice.operator.OperatorOrder;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;

public final class AddToList
extends Operator {
    public AddToList(int maxNumberOfElements, boolean keepChildrenRolls) {
        super("+", Operator.Associativity.RIGHT, OperatorOrder.getOderNumberOf(AddToList.class), Operator.Associativity.LEFT, OperatorOrder.getOderNumberOf(AddToList.class), maxNumberOfElements, keepChildrenRolls);
    }

    @Override
    @NonNull
    public RollBuilder evaluate(final @NonNull List<RollBuilder> operands, final @NonNull ExpressionPosition expressionPosition) {
        if (operands == null) {
            throw new NullPointerException("operands is marked non-null but is null");
        }
        if (expressionPosition == null) {
            throw new NullPointerException("expressionPosition is marked non-null but is null");
        }
        return new RollBuilder(){

            @Override
            @NonNull
            public Optional<List<Roll>> extendRoll(@NonNull RollContext rollContext) throws ExpressionException {
                if (rollContext == null) {
                    throw new NullPointerException("rollContext is marked non-null but is null");
                }
                ImmutableList<Roll> rolls = RollBuilder.extendAllBuilder(operands, rollContext);
                ValidatorUtil.checkRollSize(expressionPosition, rolls, 1, 2);
                if (rolls.size() == 1) {
                    return Optional.of(ImmutableList.of((Object)new Roll(this.toExpression(), ((Roll)rolls.getFirst()).getElements(), RandomElementsBuilder.fromRolls(rolls, rollContext), (ImmutableList<Roll>)ImmutableList.of((Object)((Roll)rolls.getFirst())), expressionPosition, AddToList.this.maxNumberOfElements, AddToList.this.keepChildrenRolls)));
                }
                Roll left = (Roll)rolls.getFirst();
                Roll right = (Roll)rolls.get(1);
                ImmutableList res = ImmutableList.builder().addAll(left.getElements()).addAll(right.getElements()).build();
                return Optional.of(ImmutableList.of((Object)new Roll(this.toExpression(), (ImmutableList<RollElement>)res, RandomElementsBuilder.fromRolls(rolls, rollContext), (ImmutableList<Roll>)ImmutableList.of((Object)left, (Object)right), expressionPosition, AddToList.this.maxNumberOfElements, AddToList.this.keepChildrenRolls)));
            }

            @Override
            @NonNull
            public String toExpression() {
                if (operands.size() == 1) {
                    return AddToList.getRightUnaryExpression(expressionPosition, operands);
                }
                return AddToList.getBinaryOperatorExpression(expressionPosition, operands);
            }
        };
    }
}

