/*
 * Decompiled with CFR 0.152.
 */
package de.janno.evaluator.dice.operator.list;

import com.google.common.collect.ImmutableList;
import de.janno.evaluator.dice.ExpressionException;
import de.janno.evaluator.dice.ExpressionPosition;
import de.janno.evaluator.dice.Operator;
import de.janno.evaluator.dice.RandomElementsBuilder;
import de.janno.evaluator.dice.Roll;
import de.janno.evaluator.dice.RollBuilder;
import de.janno.evaluator.dice.RollContext;
import de.janno.evaluator.dice.RollElement;
import de.janno.evaluator.dice.ValidatorUtil;
import de.janno.evaluator.dice.operator.OperatorOrder;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.NonNull;

public class Count
extends Operator {
    public Count(int maxNumberOfElements, boolean keepChildrenRolls) {
        super("c", Operator.OperatorType.UNARY, Operator.Associativity.LEFT, OperatorOrder.getOderNumberOf(Count.class), maxNumberOfElements, keepChildrenRolls);
    }

    @Override
    @NonNull
    public RollBuilder evaluate(final @NonNull List<RollBuilder> operands, final @NonNull ExpressionPosition expressionPosition) throws ExpressionException {
        if (operands == null) {
            throw new NullPointerException("operands is marked non-null but is null");
        }
        if (expressionPosition == null) {
            throw new NullPointerException("expressionPosition is marked non-null but is null");
        }
        return new RollBuilder(){

            @Override
            @NonNull
            public Optional<List<Roll>> extendRoll(@NonNull RollContext rollContext) throws ExpressionException {
                if (rollContext == null) {
                    throw new NullPointerException("rollContext is marked non-null but is null");
                }
                ImmutableList<Roll> rolls = RollBuilder.extendAllBuilder(operands, rollContext);
                ValidatorUtil.checkRollSize(expressionPosition, rolls, 1, 1);
                Roll left = (Roll)rolls.getFirst();
                ImmutableList res = rolls.stream().mapToLong(result -> result.getElements().size()).sum() == 0L ? ImmutableList.of((Object)new RollElement("0", "", "")) : (ImmutableList)left.getElements().stream().collect(Collectors.groupingBy(RollElement::getTag)).entrySet().stream().map(e -> new RollElement(String.valueOf(((List)e.getValue()).size()), (String)e.getKey(), "")).collect(ImmutableList.toImmutableList());
                return Optional.of(ImmutableList.of((Object)new Roll(this.toExpression(), (ImmutableList<RollElement>)res, RandomElementsBuilder.fromRolls(rolls, rollContext), (ImmutableList<Roll>)ImmutableList.of((Object)left), expressionPosition, Count.this.maxNumberOfElements, Count.this.keepChildrenRolls)));
            }

            @Override
            @NonNull
            public String toExpression() {
                return Count.getLeftUnaryExpression(expressionPosition, operands);
            }
        };
    }
}

